/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class BulkGetOperation<K, V>
extends RetryOnFailureOperation<Map<K, V>> {
    private final int entryCount;
    private final Map<K, V> result = new HashMap();

    public BulkGetOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, int entryCount) {
        super((short)25, (short)26, codec, channelFactory, cacheName, topologyId, flags, cfg, null);
        this.entryCount = entryCount;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateVIntSize(this.entryCount));
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeVInt(buf, this.entryCount);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    protected void reset() {
        super.reset();
        this.result.clear();
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        while (buf.readUnsignedByte() == 1) {
            Object key = this.codec.readUnmarshallByteArray(buf, status, this.cfg.getClassWhiteList(), this.channelFactory.getMarshaller());
            Object value = this.codec.readUnmarshallByteArray(buf, status, this.cfg.getClassWhiteList(), this.channelFactory.getMarshaller());
            this.result.put(key, value);
            decoder.checkpoint();
        }
        this.complete(this.result);
    }
}

