/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.ParallelHotRodOperation;
import org.infinispan.client.hotrod.impl.operations.PutAllOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;

public class PutAllParallelOperation
extends ParallelHotRodOperation<Void, PutAllOperation> {
    protected final Map<byte[], byte[]> map;
    protected final long lifespan;
    private final TimeUnit lifespanTimeUnit;
    protected final long maxIdle;
    private final TimeUnit maxIdleTimeUnit;

    public PutAllParallelOperation(Codec codec, ChannelFactory channelFactory, Map<byte[], byte[]> map, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, DataFormat dataFormat) {
        super(codec, channelFactory, cacheName, topologyId, flags, cfg, dataFormat);
        this.map = map;
        this.lifespan = lifespan;
        this.lifespanTimeUnit = lifespanTimeUnit;
        this.maxIdle = maxIdle;
        this.maxIdleTimeUnit = maxIdleTimeUnit;
    }

    @Override
    protected List<PutAllOperation> mapOperations() {
        HashMap<SocketAddress, HashMap<byte[], byte[]>> splittedMaps = new HashMap<SocketAddress, HashMap<byte[], byte[]>>();
        for (Map.Entry<byte[], byte[]> entry : this.map.entrySet()) {
            SocketAddress socketAddress = this.channelFactory.getSocketAddress(entry.getKey(), this.cacheName);
            HashMap<byte[], byte[]> keyValueMap = (HashMap<byte[], byte[]>)splittedMaps.get(socketAddress);
            if (keyValueMap == null) {
                keyValueMap = new HashMap<byte[], byte[]>();
                splittedMaps.put(socketAddress, keyValueMap);
            }
            keyValueMap.put(entry.getKey(), entry.getValue());
        }
        return splittedMaps.values().stream().map(mapSubset -> new PutAllOperation(this.codec, this.channelFactory, (Map<byte[], byte[]>)mapSubset, this.cacheName, this.header.topologyId(), this.flags, this.cfg, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit, this.dataFormat)).collect(Collectors.toList());
    }

    @Override
    protected Void createCollector() {
        return null;
    }

    @Override
    protected void combine(Void collector, Void result) {
    }
}

