/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter;

import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCounterManagerFactory;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractCounterTest
extends MultiHotRodServersTest {
    private static final int NUMBER_SERVERS = 3;

    @BeforeMethod(alwaysRun=true)
    public void restoreServer() {
        if (this.servers.size() < 3) {
            while (this.servers.size() < 3) {
                this.addHotRodServer(HotRodTestingUtil.hotRodCacheConfiguration());
            }
            TestingUtil.blockUntilViewReceived((Cache)this.manager(0).getCache(), (int)3);
            for (int i = 0; i < 3; ++i) {
                TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(i).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
            }
        }
        this.waitForClusterToForm("org.infinispan.COUNTER");
    }

    List<CounterManager> counterManagers() {
        return this.clients.stream().map(RemoteCounterManagerFactory::asCounterManager).collect(Collectors.toList());
    }

    CounterManager counterManager() {
        return RemoteCounterManagerFactory.asCounterManager((RemoteCacheManager)this.client(0));
    }

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(3, HotRodTestingUtil.hotRodCacheConfiguration());
    }
}

