/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.counter.BaseCounterAPITest;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.server.hotrod.counter.StrongCounterTestStrategy;
import org.infinispan.server.hotrod.counter.impl.StrongCounterImplTestStrategy;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.counter.StrongCounterAPITest")
public class StrongCounterAPITest
extends BaseCounterAPITest<StrongCounter>
implements StrongCounterTestStrategy {
    private final StrongCounterImplTestStrategy strategy = new StrongCounterImplTestStrategy(this::counterManager, this::counterManagers);

    public void testCompareAndSet(Method method) {
        this.strategy.testCompareAndSet(method);
    }

    public void testCompareAndSwap(Method method) {
        this.strategy.testCompareAndSwap(method);
    }

    public void testBoundaries(Method method) {
        this.strategy.testBoundaries(method);
    }

    @Test(groups={"unstable"}, description="ISPN-9053")
    public void testListenerWithBounds(Method method) throws InterruptedException {
        this.strategy.testListenerWithBounds(method);
    }

    public void testAdd(Method method) {
        this.strategy.testAdd(method);
    }

    public void testReset(Method method) {
        this.strategy.testReset(method);
    }

    public void testNameAndConfigurationTest(Method method) {
        this.strategy.testNameAndConfigurationTest(method);
    }

    public void testRemove(Method method) {
        this.strategy.testRemove(method);
    }

    @Test(groups={"unstable"}, description="ISPN-9053")
    public void testListenerAddAndRemove(Method method) throws InterruptedException {
        this.strategy.testListenerAddAndRemove(method);
    }

    @Override
    @Test(groups={"unstable"}, description="ISPN-9053")
    public void testExceptionInListener(Method method) throws InterruptedException {
        super.testExceptionInListener(method);
    }

    @Override
    @Test(groups={"unstable"}, description="ISPN-9053")
    public void testConcurrentListenerAddAndRemove(Method method) throws InterruptedException {
        super.testConcurrentListenerAddAndRemove(method);
    }

    @Override
    @Test(groups={"unstable"}, description="ISPN-9053")
    public void testListenerFailover(Method method) throws Exception {
        super.testListenerFailover(method);
    }

    @Override
    void increment(StrongCounter counter) {
        counter.sync().incrementAndGet();
    }

    @Override
    void add(StrongCounter counter, long delta, long result) {
        this.strategy.add(counter, delta, result);
    }

    @Override
    StrongCounter defineAndCreateCounter(String counterName, long initialValue) {
        return this.strategy.defineAndCreateCounter(counterName, initialValue);
    }

    @Override
    <L extends CounterListener> Handle<L> addListenerTo(StrongCounter counter, L logger) {
        return this.strategy.addListenerTo(counter, logger);
    }

    @Override
    List<StrongCounter> getCounters(String name) {
        return this.counterManagers().stream().map(counterManager -> counterManager.getStrongCounter(name)).collect(Collectors.toList());
    }
}

