/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientEvents;
import org.infinispan.client.hotrod.event.IncorrectClientListenerException;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.marshall.EmbeddedUserMarshaller;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.GenderMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Index;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.client.FilterResult;
import org.infinispan.query.remote.impl.filter.IckleCacheEventFilterConverterFactory;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientListenerWithDslFilterObjectStorageTest")
public class ClientListenerWithDslFilterObjectStorageTest
extends MultiHotRodServersTest {
    private final int NUM_NODES = 5;
    private RemoteCache<Object, Object> remoteCache;

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cfgBuilder = this.getConfigurationBuilder();
        this.createHotRodServers(5, cfgBuilder);
        this.waitForClusterToForm();
        IckleCacheEventFilterConverterFactory factory = new IckleCacheEventFilterConverterFactory();
        for (int i = 0; i < 5; ++i) {
            this.server(i).addCacheEventFilterConverterFactory("query-dsl-filter-converter-factory", (CacheEventFilterConverterFactory)factory);
        }
        this.remoteCache = this.client(0).getCache();
        RemoteCache metadataCache = this.client(0).getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        for (int i = 0; i < 5; ++i) {
            ProtobufMetadataManager protobufMetadataManager = (ProtobufMetadataManager)this.manager(i).getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
            protobufMetadataManager.registerMarshaller((BaseMarshaller)new EmbeddedUserMarshaller());
            protobufMetadataManager.registerMarshaller((BaseMarshaller)new GenderMarshaller());
        }
        MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.client(0)));
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder getConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder cfgBuilder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)ClientListenerWithDslFilterObjectStorageTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        cfgBuilder.encoding().key().mediaType("application/x-java-object");
        cfgBuilder.encoding().value().mediaType("application/x-java-object");
        cfgBuilder.indexing().index(Index.ALL).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return cfgBuilder;
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        return super.createHotRodClientConfigurationBuilder(serverPort).marshaller((Marshaller)new ProtoStreamMarshaller());
    }

    public void testEventFilter() throws Exception {
        UserPB user1 = new UserPB();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAge(22);
        user1.setAccountIds(new HashSet<Integer>(Arrays.asList(1, 2)));
        user1.setNotes("Lorem ipsum dolor sit amet");
        UserPB user2 = new UserPB();
        user2.setId(2);
        user2.setName("Spider");
        user2.setSurname("Man");
        user2.setGender(User.Gender.MALE);
        user2.setAge(32);
        user2.setAccountIds(Collections.singleton(3));
        UserPB user3 = new UserPB();
        user3.setId(3);
        user3.setName("Spider");
        user3.setSurname("Woman");
        user3.setGender(User.Gender.FEMALE);
        user3.setAge(31);
        this.remoteCache.clear();
        this.remoteCache.put((Object)("user_" + user1.getId()), (Object)user1);
        this.remoteCache.put((Object)("user_" + user2.getId()), (Object)user2);
        this.remoteCache.put((Object)("user_" + user3.getId()), (Object)user3);
        AssertJUnit.assertEquals((int)3, (int)this.remoteCache.size());
        SerializationContext serCtx = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.client(0));
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = (Query)qf.from(UserPB.class).having("age").lte((Object)Expression.param((String)"ageParam")).select(new String[]{"age"}).build().setParameter("ageParam", (Object)32);
        ClientEntryListener listener = new ClientEntryListener(serCtx);
        ClientEvents.addClientQueryListener(this.remoteCache, (Object)listener, (Query)query);
        this.expectElementsInQueue(listener.createEvents, 3);
        user3.setAge(40);
        this.remoteCache.put((Object)("user_" + user1.getId()), (Object)user1);
        this.remoteCache.put((Object)("user_" + user2.getId()), (Object)user2);
        this.remoteCache.put((Object)("user_" + user3.getId()), (Object)user3);
        AssertJUnit.assertEquals((int)3, (int)this.remoteCache.size());
        this.expectElementsInQueue(listener.modifyEvents, 2);
        this.remoteCache.removeClientListener((Object)listener);
    }

    public void testEventFilterChangingParameter() throws Exception {
        UserPB user1 = new UserPB();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAge(22);
        user1.setAccountIds(new HashSet<Integer>(Arrays.asList(1, 2)));
        user1.setNotes("Lorem ipsum dolor sit amet");
        UserPB user2 = new UserPB();
        user2.setId(2);
        user2.setName("Spider");
        user2.setSurname("Man");
        user2.setGender(User.Gender.MALE);
        user2.setAge(32);
        user2.setAccountIds(Collections.singleton(3));
        UserPB user3 = new UserPB();
        user3.setId(3);
        user3.setName("Spider");
        user3.setSurname("Woman");
        user3.setGender(User.Gender.FEMALE);
        user3.setAge(31);
        this.remoteCache.clear();
        this.remoteCache.put((Object)("user_" + user1.getId()), (Object)user1);
        this.remoteCache.put((Object)("user_" + user2.getId()), (Object)user2);
        this.remoteCache.put((Object)("user_" + user3.getId()), (Object)user3);
        AssertJUnit.assertEquals((int)3, (int)this.remoteCache.size());
        SerializationContext serCtx = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.client(0));
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = (Query)qf.from(UserPB.class).having("age").lte((Object)Expression.param((String)"ageParam")).select(new String[]{"age"}).build().setParameter("ageParam", (Object)32);
        ClientEntryListener listener = new ClientEntryListener(serCtx);
        ClientEvents.addClientQueryListener(this.remoteCache, (Object)listener, (Query)query);
        this.expectElementsInQueue(listener.createEvents, 3);
        this.remoteCache.removeClientListener((Object)listener);
        query.setParameter("ageParam", (Object)31);
        listener = new ClientEntryListener(serCtx);
        ClientEvents.addClientQueryListener(this.remoteCache, (Object)listener, (Query)query);
        this.expectElementsInQueue(listener.createEvents, 2);
        this.remoteCache.removeClientListener((Object)listener);
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN028509:.*")
    public void testDisallowGroupingAndAggregation() {
        Query query = Search.getQueryFactory(this.remoteCache).from(UserPB.class).having("age").gte((Object)20).select(new Expression[]{Expression.max((String)"age")}).build();
        ClientEntryListener listener = new ClientEntryListener(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.client(0)));
        ClientEvents.addClientQueryListener(this.remoteCache, (Object)listener, (Query)query);
    }

    @Test(expectedExceptions={IncorrectClientListenerException.class}, expectedExceptionsMessageRegExp="ISPN004058:.*")
    public void testRequireRawDataListener() {
        Query query = Search.getQueryFactory(this.remoteCache).from(UserPB.class).having("age").gte((Object)20).build();
        @ClientListener(filterFactoryName="query-dsl-filter-converter-factory", converterFactoryName="query-dsl-filter-converter-factory", useRawData=false, includeCurrentState=true)
        class DummyListener {
            DummyListener() {
            }

            @ClientCacheEntryCreated
            public void handleClientCacheEntryCreatedEvent(ClientCacheEntryCustomEvent event) {
            }
        }
        ClientEvents.addClientQueryListener(this.remoteCache, (Object)new DummyListener(), (Query)query);
    }

    @Test(expectedExceptions={IncorrectClientListenerException.class}, expectedExceptionsMessageRegExp="ISPN004059:.*")
    public void testRequireQueryDslFilterFactoryNameForListener() {
        Query query = Search.getQueryFactory(this.remoteCache).from(UserPB.class).having("age").gte((Object)20).build();
        @ClientListener(filterFactoryName="some-filter-factory-name", converterFactoryName="some-filter-factory-name", useRawData=true, includeCurrentState=true)
        class DummyListener {
            DummyListener() {
            }

            @ClientCacheEntryCreated
            public void handleClientCacheEntryCreatedEvent(ClientCacheEntryCustomEvent event) {
            }
        }
        ClientEvents.addClientQueryListener(this.remoteCache, (Object)new DummyListener(), (Query)query);
    }

    private void expectElementsInQueue(BlockingQueue<?> queue, int numElements) {
        for (int i = 0; i < numElements; ++i) {
            try {
                Object e = queue.poll(5L, TimeUnit.SECONDS);
                AssertJUnit.assertNotNull((String)"Queue was empty!", e);
                continue;
            }
            catch (InterruptedException e) {
                throw new AssertionError("Interrupted while waiting for condition", e);
            }
        }
        try {
            Object e = queue.poll(5L, TimeUnit.SECONDS);
            AssertJUnit.assertNull((String)"No more elements expected in queue!", e);
        }
        catch (InterruptedException e) {
            throw new AssertionError("Interrupted while waiting for condition", e);
        }
    }

    @ClientListener(filterFactoryName="query-dsl-filter-converter-factory", converterFactoryName="query-dsl-filter-converter-factory", useRawData=true, includeCurrentState=true)
    private static class ClientEntryListener {
        private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
        public final BlockingQueue<FilterResult> createEvents = new LinkedBlockingQueue<FilterResult>();
        public final BlockingQueue<FilterResult> modifyEvents = new LinkedBlockingQueue<FilterResult>();
        private final SerializationContext serializationContext;

        public ClientEntryListener(SerializationContext serializationContext) {
            this.serializationContext = serializationContext;
        }

        @ClientCacheEntryCreated
        public void handleClientCacheEntryCreatedEvent(ClientCacheEntryCustomEvent event) throws IOException {
            byte[] eventData = (byte[])event.getEventData();
            FilterResult r = (FilterResult)ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.serializationContext, (byte[])eventData);
            this.createEvents.add(r);
            log.debugf("handleClientCacheEntryCreatedEvent instance=%s projection=%s sortProjection=%s\n", r.getInstance(), r.getProjection() == null ? null : Arrays.asList(r.getProjection()), r.getSortProjection() == null ? null : Arrays.asList(r.getSortProjection()));
        }

        @ClientCacheEntryModified
        public void handleClientCacheEntryModifiedEvent(ClientCacheEntryCustomEvent event) throws IOException {
            byte[] eventData = (byte[])event.getEventData();
            FilterResult r = (FilterResult)ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.serializationContext, (byte[])eventData);
            this.modifyEvents.add(r);
            log.debugf("handleClientCacheEntryModifiedEvent instance=%s projection=%s sortProjection=%s\n", r.getInstance(), r.getProjection() == null ? null : Arrays.asList(r.getProjection()), r.getSortProjection() == null ? null : Arrays.asList(r.getSortProjection()));
        }

        @ClientCacheEntryRemoved
        public void handleClientCacheEntryRemovedEvent(ClientCacheEntryRemovedEvent event) {
            log.debugf("handleClientCacheEntryRemovedEvent %s\n", event.getKey());
        }
    }
}

