/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheFailover;
import org.infinispan.client.hotrod.event.ClientCacheFailoverEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.EventLogListener;

public class FailoverEventLogListener<K>
extends EventLogListener<K> {
    public BlockingQueue<ClientCacheFailoverEvent> failoverEvents = new ArrayBlockingQueue<ClientCacheFailoverEvent>(128);

    public FailoverEventLogListener(RemoteCache<K, ?> remote) {
        super(remote);
    }

    @Override
    public <E extends ClientEvent> BlockingQueue<E> queue(ClientEvent.Type type) {
        switch (type) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                return this.createdEvents;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                return this.modifiedEvents;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                return this.removedEvents;
            }
            case CLIENT_CACHE_FAILOVER: {
                return this.failoverEvents;
            }
        }
        throw new IllegalArgumentException("Unknown event type: " + type);
    }

    @ClientCacheFailover
    public void handleFailover(ClientCacheFailoverEvent e) {
        this.failoverEvents.add(e);
    }
}

