/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.marshall.PrimitiveProtoStreamMarshallerTest", groups={"functional"})
public class PrimitiveProtoStreamMarshallerTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Object, Object> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testPutAndGet() {
        this.putAndGet(1, "bar");
        this.putAndGet(1, true);
        this.putAndGet(1, 7);
        this.putAndGet(1, 777L);
        this.putAndGet(1, 0.0);
        this.putAndGet(1, 1.0);
    }

    private void putAndGet(Object key, Object value) {
        this.remoteCache.clear();
        this.remoteCache.put(key, value);
        AssertJUnit.assertTrue((boolean)this.remoteCache.keySet().contains(key));
        Object remoteValue = this.remoteCache.get(key);
        AssertJUnit.assertEquals((Object)value, (Object)remoteValue);
        AssertJUnit.assertEquals((int)1, (int)this.cache.keySet().size());
        Object localKey = this.cache.keySet().iterator().next();
        AssertJUnit.assertTrue((boolean)(localKey instanceof byte[]));
        Object localObject = this.cache.get(localKey);
        AssertJUnit.assertNotNull((Object)localObject);
        AssertJUnit.assertTrue((boolean)(localObject instanceof byte[]));
    }
}

