/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.near.AssertsNearCache;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.near.EvictInvalidatedNearCacheTest")
public class EvictInvalidatedNearCacheTest
extends SingleHotRodServerTest {
    AssertsNearCache<Integer, String> assertClient;

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        this.assertClient = this.createClient();
        return this.assertClient.manager;
    }

    protected <K, V> AssertsNearCache<K, V> createClient() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        builder.nearCache().mode(this.getNearCacheMode()).maxEntries(2);
        return AssertsNearCache.create(this.cache(), builder);
    }

    protected NearCacheMode getNearCacheMode() {
        return NearCacheMode.INVALIDATED;
    }

    public void testEvictAfterReachingMax() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1);
        this.assertClient.put(2, "v1").expectNearPreemptiveRemove(2);
        this.assertClient.get(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
        this.assertClient.get(2, "v1").expectNearGetNull(2).expectNearPutIfAbsent(2, "v1");
        this.assertClient.put(3, "v1").expectNearPreemptiveRemove(3);
        this.assertClient.get(3, "v1").expectNearGetNull(3).expectNearPutIfAbsent(3, "v1");
        this.assertClient.get(2, "v1").expectNearGetValue(2, "v1");
        this.assertClient.get(3, "v1").expectNearGetValue(3, "v1");
    }
}

