/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.News;
import org.infinispan.client.hotrod.query.NewsKey;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.query.indexmanager.InfinispanIndexManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.MultiServerStoreQueryTest", groups={"functional"})
public class MultiServerStoreQueryTest
extends MultiHotRodServersTest {
    private static final int NODES = 2;
    private static final boolean USE_PERSISTENCE = true;
    private static final String USER_CACHE = "news";
    private static final String LUCENE_LOCKING_CACHE = "LuceneIndexesLocking_news";
    private static final String LUCENE_METADATA_CACHE = "LuceneIndexesMetadata_news";
    private static final String LUCENE_DATA_CACHE = "LuceneIndexesData_news";
    private RemoteCache<Object, Object> userCache;

    public Configuration getLockCacheConfig() {
        return MultiServerStoreQueryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false).build();
    }

    public Configuration getLuceneCacheConfig(String storeName) {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = MultiServerStoreQueryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).preload(true)).storeName(storeName);
        return builder.build();
    }

    public Configuration buildIndexedConfig(String storeName) {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)MultiServerStoreQueryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.indexing().index(Index.PRIMARY_OWNER).addProperty("default.indexmanager", InfinispanIndexManager.class.getName()).addProperty("default.worker.execution", "async").addProperty("default.index_flush_interval", "500").addProperty("default.indexwriter.merge_factor", "30").addProperty("default.indexwriter.merge_max_size", "1024").addProperty("default.indexwriter.ram_buffer_size", "256").addProperty("default.locking_cachename", LUCENE_LOCKING_CACHE).addProperty("default.data_cachename", LUCENE_DATA_CACHE).addProperty("default.metadata_cachename", LUCENE_METADATA_CACHE);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).preload(true)).storeName(storeName);
        return builder.build();
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder defaultConfiguration = new org.infinispan.configuration.cache.ConfigurationBuilder();
        this.createHotRodServers(2, defaultConfiguration);
        for (int i = 0; i < this.cacheManagers.size(); ++i) {
            EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.get(i);
            cm.defineConfiguration(USER_CACHE, this.buildIndexedConfig("News-" + i));
            cm.defineConfiguration(LUCENE_LOCKING_CACHE, this.getLockCacheConfig());
            cm.defineConfiguration(LUCENE_METADATA_CACHE, this.getLuceneCacheConfig("LuceneIndexesMetadata_news_" + i));
            cm.defineConfiguration(LUCENE_DATA_CACHE, this.getLuceneCacheConfig("LuceneIndexesData_news_" + i));
            cm.getCache(USER_CACHE);
        }
        this.waitForClusterToForm(USER_CACHE);
        RemoteCacheManager remoteCacheManager = this.client(0);
        this.userCache = remoteCacheManager.getCache(USER_CACHE);
        SerializationContext serializationContext = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)remoteCacheManager);
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        String protoFile = protoSchemaBuilder.fileName("news.proto").addClass(News.class).addClass(NewsKey.class).build(serializationContext);
        RemoteCache metadataCache = remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"news.proto", (Object)protoFile);
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        return super.createHotRodClientConfigurationBuilder(serverPort).marshaller((Marshaller)new ProtoStreamMarshaller());
    }

    public void testIndexing() {
        News news = new News();
        news.setId("testnews");
        news.setTimestamp(0L);
        this.userCache.put((Object)news.getId(), (Object)news);
        Object testNews = this.userCache.get((Object)"testnews");
        AssertJUnit.assertEquals((Object)news, (Object)testNews);
    }

    public void testNonPrimitiveKey() {
        NewsKey newsKey1 = new NewsKey();
        newsKey1.setArticle("articleKey1");
        NewsKey newsKey2 = new NewsKey();
        newsKey2.setArticle("articleKey2");
        News news1 = new News();
        news1.setId("test-news-1");
        news1.setTimestamp(0L);
        News news2 = new News();
        news2.setId("test-news-2");
        news2.setTimestamp(0L);
        this.userCache.put((Object)newsKey1, (Object)news1);
        this.userCache.put((Object)newsKey2, (Object)news2);
        AssertJUnit.assertEquals((Object)news1, (Object)this.userCache.get((Object)newsKey1));
        AssertJUnit.assertEquals((Object)news2, (Object)this.userCache.get((Object)newsKey2));
    }
}

