/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.stress;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.EmbeddedUserMarshaller;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Index;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="client.hotrod.stress.RemoteQueryDslPerfTest", timeOut=900000L)
public class RemoteQueryDslPerfTest
extends MultipleCacheManagersTest {
    protected HotRodServer hotRodServer;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;
    protected Cache<Object, Object> cache;

    protected void clearContent() {
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.encoding().key().mediaType("application/x-java-object");
        builder.encoding().value().mediaType("application/x-java-object");
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        this.createClusteredCaches(1, builder);
        this.cache = this.manager(0).getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.manager(0));
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        ProtobufMetadataManager protobufMetadataManager = (ProtobufMetadataManager)this.manager(0).getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        protobufMetadataManager.registerProtofile("sample_bank_account/bank.proto", Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
        AssertJUnit.assertNull((Object)protobufMetadataManager.getFileErrors("sample_bank_account/bank.proto"));
        AssertJUnit.assertNull((Object)protobufMetadataManager.getFilesWithErrors());
        protobufMetadataManager.registerMarshaller((BaseMarshaller)new EmbeddedUserMarshaller());
        MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager));
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    @BeforeClass(alwaysRun=true)
    protected void populateCache() throws Exception {
        int loops = 10000;
        for (int i = 0; i < 10000; ++i) {
            UserHS user1 = new UserHS();
            int id1 = i * 10 + 1;
            user1.setId(id1);
            user1.setName("John" + id1);
            user1.setSurname("Doe" + id1);
            user1.setAge(Integer.valueOf(22));
            user1.setAccountIds(new HashSet<Integer>(Arrays.asList(1, 2)));
            user1.setNotes("Lorem ipsum dolor sit amet");
            UserHS user2 = new UserHS();
            int id2 = i * 10 + 2;
            user2.setId(id2);
            user2.setName("Spider" + id2);
            user2.setSurname("Man" + id2);
            user2.setAccountIds(Collections.singleton(3));
            UserHS user3 = new UserHS();
            int id3 = i * 10 + 3;
            user3.setId(id3);
            user3.setName("Spider" + id3);
            user3.setSurname("Woman" + id3);
            this.cache.put((Object)("user_" + user1.getId()), (Object)user1);
            this.cache.put((Object)("user_" + user2.getId()), (Object)user2);
            this.cache.put((Object)("user_" + user3.getId()), (Object)user3);
        }
    }

    public void testRemoteQueryDslExecution() throws Exception {
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        QueryBuilder qb = qf.from("sample_bank_account.User").having("name").eq((Object)"John1");
        int loops = 100000;
        long startTs = System.nanoTime();
        for (int i = 0; i < 100000; ++i) {
            Query q = qb.build();
            List list = q.list();
            AssertJUnit.assertEquals((int)1, (int)list.size());
            AssertJUnit.assertEquals((String)"John1", (String)((User)list.get(0)).getName());
        }
        long duration = (System.nanoTime() - startTs) / 100000L;
        System.out.printf("Remote execution took %d us per query\n", TimeUnit.NANOSECONDS.toMicros(duration));
    }

    public void testEmbeddedQueryDslExecution() throws Exception {
        QueryFactory qf = org.infinispan.query.Search.getQueryFactory(this.cache);
        QueryBuilder qb = qf.from(UserHS.class).having("name").eq((Object)"John1");
        int loops = 100000;
        long startTs = System.nanoTime();
        for (int i = 0; i < 100000; ++i) {
            Query q = qb.build();
            List list = q.list();
            AssertJUnit.assertEquals((int)1, (int)list.size());
            AssertJUnit.assertEquals((String)"John1", (String)((User)list.get(0)).getName());
        }
        long duration = (System.nanoTime() - startTs) / 100000L;
        System.out.printf("Embedded execution took %d us per query\n", TimeUnit.NANOSECONDS.toMicros(duration));
    }

    public void testEmbeddedLuceneQueryExecution() throws Exception {
        SearchManager searchManager = org.infinispan.query.Search.getSearchManager(this.cache);
        org.apache.lucene.search.Query query = searchManager.buildQueryBuilderForClass(UserHS.class).get().keyword().onField("name").matching((Object)"John1").createQuery();
        int loops = 100000;
        long startTs = System.nanoTime();
        for (int i = 0; i < 100000; ++i) {
            CacheQuery cacheQuery = searchManager.getQuery(query, new Class[0]);
            List list = cacheQuery.list();
            AssertJUnit.assertEquals((int)1, (int)list.size());
            AssertJUnit.assertEquals((String)"John1", (String)((User)list.get(0)).getName());
        }
        long duration = (System.nanoTime() - startTs) / 100000L;
        System.out.printf("Embedded HS execution took %d us per query\n", TimeUnit.NANOSECONDS.toMicros(duration));
    }
}

