/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.infinispan.client.hotrod.jmx.RemoteCacheClientStatisticsMXBean;
import org.infinispan.client.hotrod.near.NearCacheService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.concurrent.StripedCounters;

public class ClientStatistics
implements RemoteCacheClientStatisticsMXBean {
    private final boolean enabled;
    private final AtomicLong startNanoseconds = new AtomicLong(0L);
    private final AtomicLong resetNanoseconds = new AtomicLong(0L);
    private final NearCacheService nearCacheService;
    private final TimeService timeService;
    private StripedCounters<StripeB> counters = new StripedCounters(() -> new StripeC());

    ClientStatistics(boolean enabled, TimeService timeService, NearCacheService nearCacheService) {
        this.enabled = enabled;
        this.timeService = timeService;
        this.nearCacheService = nearCacheService;
        if (nearCacheService != null) {
            nearCacheService.setInvalidationCallback(() -> this.incrementNearCacheInvalidations());
        }
    }

    ClientStatistics(boolean enabled, TimeService timeService) {
        this(enabled, timeService, null);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public long getRemoteHits() {
        return this.counters.get(StripeB.remoteCacheHitsFieldUpdater);
    }

    @Override
    public long getRemoteMisses() {
        return this.counters.get(StripeB.remoteCacheMissesFieldUpdater);
    }

    @Override
    public long getAverageRemoteReadTime() {
        long total = this.counters.get(StripeB.remoteCacheHitsFieldUpdater) + this.counters.get(StripeB.remoteCacheMissesFieldUpdater);
        if (total == 0L) {
            return 0L;
        }
        total = (this.counters.get(StripeB.remoteCacheHitsTimeFieldUpdater) + this.counters.get(StripeB.remoteCacheMissesTimeFieldUpdater)) / total;
        return TimeUnit.NANOSECONDS.toMillis(total);
    }

    @Override
    public long getRemoteStores() {
        return this.counters.get(StripeB.remoteCacheStoresFieldUpdater);
    }

    @Override
    public long getAverageRemoteStoreTime() {
        long total = this.counters.get(StripeB.remoteCacheStoresFieldUpdater);
        if (total == 0L) {
            return 0L;
        }
        total = this.counters.get(StripeB.remoteCacheStoresTimeFieldUpdater) / total;
        return TimeUnit.NANOSECONDS.toMillis(total);
    }

    @Override
    public long getRemoteRemoves() {
        return this.counters.get(StripeB.remoteCacheRemovesFieldUpdater);
    }

    @Override
    public long getAverageRemoteRemovesTime() {
        long total = this.counters.get(StripeB.remoteCacheRemovesFieldUpdater);
        if (total == 0L) {
            return 0L;
        }
        total = this.counters.get(StripeB.remoteCacheRemovesTimeFieldUpdater) / total;
        return TimeUnit.NANOSECONDS.toMillis(total);
    }

    @Override
    public long getNearCacheHits() {
        return this.counters.get(StripeB.nearCacheHitsFieldUpdater);
    }

    @Override
    public long getNearCacheMisses() {
        return this.counters.get(StripeB.nearCacheMissesFieldUpdater);
    }

    @Override
    public long getNearCacheInvalidations() {
        return this.counters.get(StripeB.nearCacheInvalidationsFieldUpdater);
    }

    @Override
    public long getNearCacheSize() {
        return this.nearCacheService != null ? (long)this.nearCacheService.size() : 0L;
    }

    public long time() {
        return this.timeService.time();
    }

    public void dataRead(boolean foundValue, long startTimeNanoSeconds, int count) {
        long duration = this.timeService.timeDuration(startTimeNanoSeconds, TimeUnit.MILLISECONDS);
        StripeB stripe = (StripeB)this.counters.stripeForCurrentThread();
        if (foundValue) {
            this.counters.add(StripeB.remoteCacheHitsTimeFieldUpdater, (Object)stripe, duration);
            this.counters.add(StripeB.remoteCacheHitsFieldUpdater, (Object)stripe, (long)count);
        } else {
            this.counters.add(StripeB.remoteCacheMissesTimeFieldUpdater, (Object)stripe, duration);
            this.counters.add(StripeB.remoteCacheMissesFieldUpdater, (Object)stripe, (long)count);
        }
    }

    public void dataStore(long startTimeNanoSeconds, int count) {
        long duration = this.timeService.timeDuration(startTimeNanoSeconds, TimeUnit.MILLISECONDS);
        StripeB stripe = (StripeB)this.counters.stripeForCurrentThread();
        this.counters.add(StripeB.remoteCacheStoresTimeFieldUpdater, (Object)stripe, duration);
        this.counters.add(StripeB.remoteCacheStoresFieldUpdater, (Object)stripe, (long)count);
    }

    public void dataRemove(long startTimeNanoSeconds, int count) {
        long duration = this.timeService.timeDuration(startTimeNanoSeconds, TimeUnit.MILLISECONDS);
        StripeB stripe = (StripeB)this.counters.stripeForCurrentThread();
        this.counters.add(StripeB.remoteCacheRemovesTimeFieldUpdater, (Object)stripe, duration);
        this.counters.add(StripeB.remoteCacheRemovesFieldUpdater, (Object)stripe, (long)count);
    }

    public void incrementNearCacheMisses() {
        this.counters.increment(StripeB.nearCacheMissesFieldUpdater, this.counters.stripeForCurrentThread());
    }

    public void incrementNearCacheHits() {
        this.counters.increment(StripeB.nearCacheHitsFieldUpdater, this.counters.stripeForCurrentThread());
    }

    public void incrementNearCacheInvalidations() {
        this.counters.increment(StripeB.nearCacheInvalidationsFieldUpdater, this.counters.stripeForCurrentThread());
    }

    @Override
    public void resetStatistics() {
        this.counters.reset(StripeB.remoteCacheHitsFieldUpdater);
        this.counters.reset(StripeB.remoteCacheHitsTimeFieldUpdater);
        this.counters.reset(StripeB.remoteCacheMissesFieldUpdater);
        this.counters.reset(StripeB.remoteCacheMissesTimeFieldUpdater);
        this.counters.reset(StripeB.remoteCacheRemovesFieldUpdater);
        this.counters.reset(StripeB.remoteCacheRemovesTimeFieldUpdater);
        this.counters.reset(StripeB.remoteCacheStoresFieldUpdater);
        this.counters.reset(StripeB.remoteCacheStoresTimeFieldUpdater);
        this.counters.reset(StripeB.nearCacheHitsFieldUpdater);
        this.counters.reset(StripeB.nearCacheMissesFieldUpdater);
        this.counters.reset(StripeB.nearCacheInvalidationsFieldUpdater);
        this.startNanoseconds.set(this.timeService.time());
        this.resetNanoseconds.set(this.startNanoseconds.get());
    }

    @Override
    public long getTimeSinceReset() {
        return this.timeService.timeDuration(this.resetNanoseconds.get(), TimeUnit.SECONDS);
    }

    private static class StripeC
    extends StripeB {
        private long slack1;
        private long slack2;
        private long slack3;
        private long slack4;
        private long slack5;
        private long slack6;
        private long slack7;
        private long slack8;

        private StripeC() {
        }
    }

    private static class StripeB
    extends StripeA {
        static final AtomicLongFieldUpdater<StripeB> remoteCacheHitsFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "remoteCacheHits");
        static final AtomicLongFieldUpdater<StripeB> remoteCacheHitsTimeFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "remoteCacheHitsTime");
        static final AtomicLongFieldUpdater<StripeB> remoteCacheMissesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "remoteCacheMisses");
        static final AtomicLongFieldUpdater<StripeB> remoteCacheMissesTimeFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "remoteCacheMissesTime");
        static final AtomicLongFieldUpdater<StripeB> remoteCacheRemovesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "remoteCacheRemoves");
        static final AtomicLongFieldUpdater<StripeB> remoteCacheRemovesTimeFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "remoteCacheRemovesTime");
        static final AtomicLongFieldUpdater<StripeB> remoteCacheStoresFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "remoteCacheStores");
        static final AtomicLongFieldUpdater<StripeB> remoteCacheStoresTimeFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "remoteCacheStoresTime");
        static final AtomicLongFieldUpdater<StripeB> nearCacheHitsFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "nearCacheHits");
        static final AtomicLongFieldUpdater<StripeB> nearCacheMissesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "nearCacheMisses");
        static final AtomicLongFieldUpdater<StripeB> nearCacheInvalidationsFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "nearCacheInvalidations");
        private volatile long remoteCacheHits = 0L;
        private volatile long remoteCacheHitsTime = 0L;
        private volatile long remoteCacheMisses = 0L;
        private volatile long remoteCacheMissesTime = 0L;
        private volatile long remoteCacheRemoves = 0L;
        private volatile long remoteCacheRemovesTime = 0L;
        private volatile long remoteCacheStores = 0L;
        private volatile long remoteCacheStoresTime = 0L;
        private volatile long nearCacheHits = 0L;
        private volatile long nearCacheMisses = 0L;
        private volatile long nearCacheInvalidations = 0L;

        private StripeB() {
        }
    }

    private static class StripeA {
        private long slack1;
        private long slack2;
        private long slack3;
        private long slack4;
        private long slack5;
        private long slack6;
        private long slack7;
        private long slack8;

        private StripeA() {
        }
    }
}

