/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp;

import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestCacheManagerClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.impl.okhttp.RestClientOkHttp;

public class RestCacheManagerClientOkHttp
implements RestCacheManagerClient {
    private final RestClientOkHttp client;
    private final String name;
    private final String baseCacheManagerUrl;

    RestCacheManagerClientOkHttp(RestClientOkHttp client, String name) {
        this.client = client;
        this.name = name;
        this.baseCacheManagerUrl = String.format("%s%s/v2/cache-managers/%s", client.getBaseURL(), client.getConfiguration().contextPath(), RestClientOkHttp.sanitize(name)).replaceAll("//", "/");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public CompletionStage<RestResponse> globalConfiguration() {
        return this.client.execute(this.baseCacheManagerUrl, "config");
    }

    @Override
    public CompletionStage<RestResponse> cacheConfigurations() {
        return this.client.execute(this.baseCacheManagerUrl, "cache-configs");
    }

    @Override
    public CompletionStage<RestResponse> info() {
        return this.client.execute(this.baseCacheManagerUrl, new String[0]);
    }

    @Override
    public CompletionStage<RestResponse> stats() {
        return this.client.execute(this.baseCacheManagerUrl, "stats");
    }

    @Override
    public CompletionStage<RestResponse> backupStatuses() {
        return this.client.execute(this.baseCacheManagerUrl, "x-site", "backups");
    }

    @Override
    public CompletionStage<RestResponse> bringBackupOnline(String backup) {
        return this.executeXSiteOperation(backup, "bring-online");
    }

    @Override
    public CompletionStage<RestResponse> takeOffline(String backup) {
        return this.executeXSiteOperation(backup, "take-offline");
    }

    @Override
    public CompletionStage<RestResponse> pushSiteState(String backup) {
        return this.executeXSiteOperation(backup, "start-push-state");
    }

    @Override
    public CompletionStage<RestResponse> cancelPushState(String backup) {
        return this.executeXSiteOperation(backup, "cancel-push-state");
    }

    private CompletionStage<RestResponse> executeXSiteOperation(String backup, String operation) {
        String url = String.format("%s/x-site/backups/%s?action=%s", this.baseCacheManagerUrl, backup, operation);
        return this.client.execute(url, new String[0]);
    }

    @Override
    public CompletionStage<RestResponse> health() {
        return this.client.execute(this.baseCacheManagerUrl, "health");
    }

    @Override
    public CompletionStage<RestResponse> healthStatus() {
        return this.client.execute(this.baseCacheManagerUrl, "health", "status");
    }
}

