/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp;

import java.util.concurrent.CompletionStage;
import okhttp3.Request;
import org.infinispan.client.rest.RestCounterClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.impl.okhttp.RestClientOkHttp;
import org.infinispan.client.rest.impl.okhttp.RestEntityAdaptorOkHttp;

public class RestCounterClientOkHttp
implements RestCounterClient {
    private final RestClientOkHttp client;
    private final String name;
    private final String counterUrl;

    RestCounterClientOkHttp(RestClientOkHttp client, String name) {
        this.client = client;
        this.name = name;
        this.counterUrl = String.format("%s%s/v2/counters/%s", client.getBaseURL(), client.getConfiguration().contextPath(), RestClientOkHttp.sanitize(name)).replaceAll("//", "/");
    }

    @Override
    public CompletionStage<RestResponse> create(RestEntity configuration) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.counterUrl).post(((RestEntityAdaptorOkHttp)((Object)configuration)).toRequestBody());
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> delete() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.counterUrl).delete();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> configuration() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.counterUrl + "/config");
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> get() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.counterUrl);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> add(long delta) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.counterUrl + "?action=add&delta=" + delta);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> increment() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.counterUrl + "?action=increment");
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> decrement() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.counterUrl + "?action=decrement");
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> reset() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.counterUrl + "?action=reset");
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> compareAndSet(long expect, long value) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.counterUrl + "?action=compareAndSet&expect=" + expect + "&update=" + value);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> compareAndSwap(long expect, long value) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.counterUrl + "?action=compareAndSet&expect=" + expect + "&update=" + value);
        return this.client.execute(builder);
    }
}

