/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp.auth;

import java.io.IOException;
import java.util.List;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.infinispan.client.rest.configuration.AuthenticationConfiguration;
import org.infinispan.client.rest.impl.okhttp.auth.BasicAuthenticator;
import org.infinispan.client.rest.impl.okhttp.auth.BearerAuthenticator;
import org.infinispan.client.rest.impl.okhttp.auth.CachingAuthenticator;
import org.infinispan.client.rest.impl.okhttp.auth.DigestAuthenticator;

public class AutoDetectAuthenticator
implements CachingAuthenticator {
    private final BasicAuthenticator basic;
    private final BearerAuthenticator bearer;
    private final DigestAuthenticator digest;

    public AutoDetectAuthenticator(AuthenticationConfiguration configuration) {
        this.basic = new BasicAuthenticator(configuration);
        this.bearer = new BearerAuthenticator(configuration);
        this.digest = new DigestAuthenticator(configuration);
    }

    public Request authenticate(Route route, Response response) throws IOException {
        List headers = response.headers("WWW-Authenticate");
        for (String header : headers) {
            String mech;
            int space = header.indexOf(32);
            switch (mech = header.substring(0, space)) {
                case "Digest": {
                    return this.digest.authenticate(route, response);
                }
                case "Basic": {
                    return this.basic.authenticate(route, response);
                }
                case "Bearer": {
                    return this.bearer.authenticate(route, response);
                }
            }
        }
        return null;
    }

    @Override
    public Request authenticateWithState(Route route, Request request) throws IOException {
        throw new IllegalStateException();
    }
}

