/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp.auth;

import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.infinispan.client.rest.configuration.AuthenticationConfiguration;
import org.infinispan.client.rest.impl.okhttp.auth.CachingAuthenticator;

public class BasicAuthenticator
implements CachingAuthenticator {
    private final AuthenticationConfiguration configuration;

    public BasicAuthenticator(AuthenticationConfiguration configuration) {
        this.configuration = configuration;
    }

    public Request authenticate(Route route, Response response) {
        Request request = response.request();
        return this.authFromRequest(request);
    }

    private Request authFromRequest(Request request) {
        String authorization = request.header("Authorization");
        if (authorization != null && authorization.startsWith("Basic")) {
            return null;
        }
        String authValue = Credentials.basic((String)this.configuration.username(), (String)new String(this.configuration.password()));
        return request.newBuilder().header("Authorization", authValue).tag(Authenticator.class, (Object)this).build();
    }

    @Override
    public Request authenticateWithState(Route route, Request request) {
        return this.authFromRequest(request);
    }
}

