/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp.auth;

import java.security.PrivilegedActionException;
import java.util.Base64;
import javax.security.auth.Subject;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.infinispan.client.rest.configuration.AuthenticationConfiguration;
import org.infinispan.client.rest.impl.okhttp.auth.AbstractAuthenticator;

public class NegotiateAuthenticator
extends AbstractAuthenticator
implements Authenticator {
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private final AuthenticationConfiguration configuration;
    private final GSSManager gssManager;
    private final Oid oid;

    public NegotiateAuthenticator(AuthenticationConfiguration configuration) {
        this.configuration = configuration;
        this.gssManager = GSSManager.getInstance();
        try {
            this.oid = new Oid(SPNEGO_OID);
        }
        catch (GSSException e) {
            throw new RuntimeException(e);
        }
    }

    public Request authenticate(Route route, Response response) {
        Request request = response.request();
        return this.authenticateInternal(route, request);
    }

    private Request authenticateInternal(Route route, Request request) {
        try {
            String host = route.address().url().host();
            byte[] token = this.generateToken(null, host);
            return request.newBuilder().header("Authorization", "Negotiate " + Base64.getEncoder().encodeToString(token)).build();
        }
        catch (GSSException e) {
            throw new AbstractAuthenticator.AuthenticationException(e.getMessage(), e);
        }
    }

    protected byte[] generateToken(byte[] input, String authServer) throws GSSException {
        GSSName serverName = this.gssManager.createName("HTTP@" + authServer, GSSName.NT_HOSTBASED_SERVICE);
        GSSContext gssContext = this.gssManager.createContext(serverName.canonicalize(this.oid), this.oid, null, 0);
        gssContext.requestMutualAuth(true);
        try {
            return Subject.doAs(this.configuration.clientSubject(), () -> input != null ? gssContext.initSecContext(input, 0, input.length) : gssContext.initSecContext(new byte[0], 0, 0));
        }
        catch (PrivilegedActionException e) {
            throw new SecurityException(e);
        }
    }
}

