/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.infinispan.client.rest.RestClusterClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.impl.okhttp.FileRestEntityOkHttp;
import org.infinispan.client.rest.impl.okhttp.RestClientOkHttp;
import org.infinispan.client.rest.impl.okhttp.StringRestEntityOkHttp;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;

public class RestClusterClientOkHttp
implements RestClusterClient {
    private final RestClientOkHttp client;
    private final String baseClusterURL;

    RestClusterClientOkHttp(RestClientOkHttp restClient) {
        this.client = restClient;
        this.baseClusterURL = String.format("%s%s/v2/cluster", restClient.getBaseURL(), restClient.getConfiguration().contextPath()).replaceAll("//", "/");
    }

    @Override
    public CompletionStage<RestResponse> stop() {
        return this.stop(Collections.emptyList());
    }

    @Override
    public CompletionStage<RestResponse> stop(List<String> servers) {
        Request.Builder builder = new Request.Builder();
        StringBuilder sb = new StringBuilder(this.baseClusterURL);
        sb.append("?action=stop");
        for (String server : servers) {
            sb.append("&server=");
            sb.append(server);
        }
        builder.post(RestClientOkHttp.EMPTY_BODY).url(sb.toString());
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> createBackup(String name) {
        RequestBody body = new StringRestEntityOkHttp(MediaType.APPLICATION_JSON, Json.object().toString()).toRequestBody();
        return this.client.execute(this.backup(name).post(body));
    }

    @Override
    public CompletionStage<RestResponse> getBackup(String name, boolean skipBody) {
        Request.Builder builder = this.backup(name);
        if (skipBody) {
            builder.head();
        }
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> getBackupNames() {
        Request.Builder builder = new Request.Builder().url(this.baseClusterURL + "/backups");
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> deleteBackup(String name) {
        return this.client.execute(this.backup(name).delete());
    }

    @Override
    public CompletionStage<RestResponse> restore(String name, File backup) {
        RequestBody zipBody = new FileRestEntityOkHttp(MediaType.APPLICATION_ZIP, backup).toRequestBody();
        MultipartBody multipartBody = new MultipartBody.Builder().addFormDataPart("backup", backup.getName(), zipBody).setType(MultipartBody.FORM).build();
        Request.Builder builder = this.restore(name).post((RequestBody)multipartBody);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> restore(String name, String backupLocation) {
        Json json = Json.object();
        json.set("location", (Object)backupLocation);
        RequestBody body = new StringRestEntityOkHttp(MediaType.APPLICATION_JSON, json.toString()).toRequestBody();
        Request.Builder builder = this.restore(name).post(body);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> getRestore(String name) {
        return this.client.execute(this.restore(name).head());
    }

    @Override
    public CompletionStage<RestResponse> getRestoreNames() {
        return this.client.execute(new Request.Builder().url(this.baseClusterURL + "/restores"));
    }

    @Override
    public CompletionStage<RestResponse> deleteRestore(String name) {
        return this.client.execute(this.restore(name).delete());
    }

    @Override
    public CompletionStage<RestResponse> distribution() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.baseClusterURL + "?action=distribution").get();
        return this.client.execute(builder);
    }

    private Request.Builder backup(String name) {
        return new Request.Builder().url(this.baseClusterURL + "/backups/" + name);
    }

    private Request.Builder restore(String name) {
        return new Request.Builder().url(this.baseClusterURL + "/restores/" + name);
    }
}

