/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestCounterClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.impl.jdk.RestClientJDK;
import org.infinispan.client.rest.impl.jdk.RestRawClientJDK;

public class RestCounterClientJDK
implements RestCounterClient {
    private final RestRawClientJDK client;
    private final String path;

    RestCounterClientJDK(RestRawClientJDK client, String name) {
        this.client = client;
        this.path = client.getConfiguration().contextPath() + "/v2/counters/" + RestClientJDK.sanitize(name);
    }

    @Override
    public CompletionStage<RestResponse> create(RestEntity configuration) {
        return this.client.post(this.path, configuration);
    }

    @Override
    public CompletionStage<RestResponse> delete() {
        return this.client.delete(this.path);
    }

    @Override
    public CompletionStage<RestResponse> configuration() {
        return this.configuration(null);
    }

    @Override
    public CompletionStage<RestResponse> configuration(String mediaType) {
        return this.client.get(this.path + "/config", mediaType != null ? Map.of("Accept", mediaType) : Collections.emptyMap());
    }

    @Override
    public CompletionStage<RestResponse> get() {
        return this.client.get(this.path);
    }

    @Override
    public CompletionStage<RestResponse> add(long delta) {
        return this.client.post(this.path + "?action=add&delta=" + delta);
    }

    @Override
    public CompletionStage<RestResponse> increment() {
        return this.client.post(this.path + "?action=increment");
    }

    @Override
    public CompletionStage<RestResponse> decrement() {
        return this.client.post(this.path + "?action=decrement");
    }

    @Override
    public CompletionStage<RestResponse> reset() {
        return this.client.post(this.path + "?action=reset");
    }

    @Override
    public CompletionStage<RestResponse> compareAndSet(long expect, long value) {
        return this.client.post(this.path + "?action=compareAndSet&expect=" + expect + "&update=" + value);
    }

    @Override
    public CompletionStage<RestResponse> compareAndSwap(long expect, long value) {
        return this.client.post(this.path + "?action=compareAndSwap&expect=" + expect + "&update=" + value);
    }

    @Override
    public CompletionStage<RestResponse> getAndSet(long newValue) {
        return this.client.post(this.path + "?action=getAndSet&value=" + newValue);
    }
}

