/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.commons.dataconversion.MediaType;

public class RestResponseJDK<T>
implements RestResponse {
    private final HttpResponse<T> response;

    public RestResponseJDK(HttpResponse<T> response) {
        this.response = response;
    }

    @Override
    public int status() {
        return this.response.statusCode();
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.response.headers().map();
    }

    @Override
    public String header(String header) {
        return this.response.headers().firstValue(header).orElse(null);
    }

    @Override
    public String body() {
        String string;
        block10: {
            T body = this.response.body();
            if (body instanceof String) {
                return (String)body;
            }
            if (body instanceof byte[]) {
                return new String((byte[])body, StandardCharsets.UTF_8);
            }
            InputStream is = (InputStream)body;
            try {
                string = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return string;
    }

    @Override
    public InputStream bodyAsStream() {
        T body = this.response.body();
        if (body instanceof InputStream) {
            return (InputStream)body;
        }
        if (body instanceof String) {
            return new ByteArrayInputStream(((String)body).getBytes(StandardCharsets.UTF_8));
        }
        return new ByteArrayInputStream((byte[])body);
    }

    @Override
    public byte[] bodyAsByteArray() {
        byte[] byArray;
        block10: {
            T body = this.response.body();
            if (body instanceof byte[]) {
                return (byte[])body;
            }
            if (body instanceof String) {
                return ((String)body).getBytes(StandardCharsets.UTF_8);
            }
            InputStream is = (InputStream)body;
            try {
                byArray = is.readAllBytes();
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return byArray;
    }

    @Override
    public Protocol protocol() {
        switch (this.response.version()) {
            case HTTP_1_1: {
                return Protocol.HTTP_11;
            }
            case HTTP_2: {
                return Protocol.HTTP_20;
            }
        }
        throw new IllegalArgumentException(this.response.version().name());
    }

    @Override
    public MediaType contentType() {
        Optional<String> contentType = this.response.headers().firstValue("Content-Type");
        return contentType.map(MediaType::fromString).orElse(null);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean usedAuthentication() {
        return this.response.request().headers().firstValue("Authorization").isPresent();
    }
}

