/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk;

import java.io.Closeable;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestEventListener;
import org.infinispan.client.rest.RestRawClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestResponseInfo;
import org.infinispan.client.rest.configuration.AuthenticationConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.ServerConfiguration;
import org.infinispan.client.rest.configuration.SslConfiguration;
import org.infinispan.client.rest.impl.jdk.RestClientThreadFactory;
import org.infinispan.client.rest.impl.jdk.RestResponseJDK;
import org.infinispan.client.rest.impl.jdk.auth.AutoDetectAuthenticator;
import org.infinispan.client.rest.impl.jdk.auth.BasicAuthenticator;
import org.infinispan.client.rest.impl.jdk.auth.BearerAuthenticator;
import org.infinispan.client.rest.impl.jdk.auth.DigestAuthenticator;
import org.infinispan.client.rest.impl.jdk.auth.HttpAuthenticator;
import org.infinispan.client.rest.impl.jdk.auth.NegotiateAuthenticator;
import org.infinispan.client.rest.impl.jdk.sse.EventSubscriber;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.SslContextFactory;

public class RestRawClientJDK
implements RestRawClient,
AutoCloseable {
    private static final AtomicLong CLIENT_IDS = new AtomicLong();
    private final RestClientConfiguration configuration;
    private final HttpAuthenticator authenticator;
    private final HttpClient httpClient;
    private final String baseURL;
    private final boolean managedExecutorService;
    private final ExecutorService executorService;

    RestRawClientJDK(RestClientConfiguration configuration) {
        this.configuration = configuration;
        HttpClient.Builder builder = HttpClient.newBuilder();
        ExecutorService executorService = configuration.executorService();
        if (executorService == null) {
            executorService = new ThreadPoolExecutor(0, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new RestClientThreadFactory(CLIENT_IDS.incrementAndGet()));
            this.managedExecutorService = true;
        } else {
            this.managedExecutorService = false;
        }
        this.executorService = executorService;
        builder.connectTimeout(Duration.ofMillis(configuration.connectionTimeout())).followRedirects(configuration.followRedirects() ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER);
        builder.executor(executorService);
        SslConfiguration ssl = configuration.security().ssl();
        if (ssl.enabled()) {
            SSLContext sslContext = ssl.sslContext();
            if (sslContext == null) {
                String sslContextFactory = new SslContextFactory().keyStoreFileName(ssl.keyStoreFileName()).keyStorePassword(ssl.keyStorePassword()).keyStoreType(ssl.keyStoreType()).trustStoreFileName(ssl.trustStoreFileName()).trustStorePassword(ssl.trustStorePassword()).trustStoreType(ssl.trustStoreType()).classLoader(Thread.currentThread().getContextClassLoader()).useNativeIfAvailable(false);
                sslContext = sslContextFactory.getContext();
            }
            builder.sslContext(sslContext);
        }
        switch (configuration.protocol()) {
            case HTTP_11: {
                builder.version(HttpClient.Version.HTTP_1_1);
                break;
            }
            case HTTP_20: {
                builder.version(HttpClient.Version.HTTP_2);
            }
        }
        this.httpClient = builder.build();
        AuthenticationConfiguration authentication = configuration.security().authentication();
        if (authentication.enabled()) {
            switch (authentication.mechanism()) {
                case "AUTO": {
                    this.authenticator = new AutoDetectAuthenticator(this.httpClient, authentication);
                    break;
                }
                case "SPNEGO": {
                    this.authenticator = new NegotiateAuthenticator(this.httpClient, authentication);
                    break;
                }
                case "DIGEST": {
                    this.authenticator = new DigestAuthenticator(this.httpClient, authentication);
                    break;
                }
                case "BASIC": {
                    this.authenticator = new BasicAuthenticator(this.httpClient, authentication);
                    break;
                }
                case "BEARER_TOKEN": {
                    this.authenticator = new BearerAuthenticator(this.httpClient, authentication);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot handle " + authentication.mechanism());
                }
            }
        } else {
            this.authenticator = null;
        }
        ServerConfiguration server = configuration.servers().get(0);
        this.baseURL = String.format("%s://%s:%d", ssl.enabled() ? "https" : "http", server.host(), server.port());
    }

    @Override
    public CompletionStage<RestResponse> post(String path, Map<String, String> headers, RestEntity entity) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().timeout(Duration.ofMillis(this.configuration.socketTimeout()));
        builder.uri(URI.create(this.baseURL + path));
        headers.forEach(builder::header);
        builder.POST(entity.bodyPublisher());
        if (entity.contentType() != null) {
            builder.header("Content-Type", entity.contentType().toString());
        }
        return this.execute(builder, this.bodyHandlerSupplier(headers));
    }

    @Override
    public CompletionStage<RestResponse> put(String path, Map<String, String> headers, RestEntity entity) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().timeout(Duration.ofMillis(this.configuration.socketTimeout()));
        builder.uri(URI.create(this.baseURL + path));
        headers.forEach(builder::header);
        builder.PUT(entity.bodyPublisher());
        if (entity.contentType() != null) {
            builder.header("Content-Type", entity.contentType().toString());
        }
        return this.execute(builder, this.bodyHandlerSupplier(headers));
    }

    @Override
    public CompletionStage<RestResponse> get(String path, Map<String, String> headers) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().timeout(Duration.ofMillis(this.configuration.socketTimeout()));
        builder.GET().uri(URI.create(this.baseURL + path));
        headers.forEach(builder::header);
        return this.execute(builder, this.bodyHandlerSupplier(headers));
    }

    @Override
    public CompletionStage<RestResponse> get(String path, Map<String, String> headers, Supplier<HttpResponse.BodyHandler<?>> supplier) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().timeout(Duration.ofMillis(this.configuration.socketTimeout()));
        builder.GET().uri(URI.create(this.baseURL + path));
        headers.forEach(builder::header);
        return this.execute(builder, supplier);
    }

    @Override
    public CompletionStage<RestResponse> delete(String path, Map<String, String> headers) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().timeout(Duration.ofMillis(this.configuration.socketTimeout()));
        builder.uri(URI.create(this.baseURL + path));
        headers.forEach(builder::header);
        builder.DELETE();
        return this.execute(builder, this.bodyHandlerSupplier(headers));
    }

    @Override
    public CompletionStage<RestResponse> options(String path, Map<String, String> headers) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().timeout(Duration.ofMillis(this.configuration.socketTimeout()));
        builder.uri(URI.create(this.baseURL + path));
        headers.forEach(builder::header);
        builder.method("OPTIONS", HttpRequest.BodyPublishers.noBody());
        return this.execute(builder, this.bodyHandlerSupplier(headers));
    }

    @Override
    public CompletionStage<RestResponse> head(String path, Map<String, String> headers) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().timeout(Duration.ofMillis(this.configuration.socketTimeout()));
        builder.uri(URI.create(this.baseURL + path));
        headers.forEach(builder::header);
        builder.method("HEAD", HttpRequest.BodyPublishers.noBody());
        return this.execute(builder, this.bodyHandlerSupplier(headers));
    }

    @Override
    public Closeable listen(String path, Map<String, String> headers, RestEventListener listener) {
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        builder.uri(URI.create(this.baseURL + path));
        headers.forEach(builder::header);
        this.configuration.headers().forEach(builder::header);
        EventSubscriber subscriber = new EventSubscriber(listener);
        this.execute(builder, subscriber::bodyHandler).handle((r, t) -> {
            if (t != null) {
                listener.onError((Throwable)t, (RestResponseInfo)r);
            } else {
                int status = r.status();
                if (status >= 300) {
                    listener.onError(null, (RestResponseInfo)r);
                }
            }
            return null;
        });
        return subscriber;
    }

    private Supplier<HttpResponse.BodyHandler<?>> bodyHandlerSupplier(Map<String, String> headers) {
        String accept = headers.get("Accept");
        String encoding = headers.get("Accept-Encoding");
        if (accept == null && encoding == null) {
            return HttpResponse.BodyHandlers::ofString;
        }
        if (encoding != null && !encoding.equals("identity")) {
            return HttpResponse.BodyHandlers::ofByteArray;
        }
        MediaType mediaType = (MediaType)MediaType.parseList((String)accept).findFirst().get();
        return switch (mediaType.getTypeSubtype()) {
            case "application/octet-stream", "application/x-protostream", "application/x-java-serialized-object" -> HttpResponse.BodyHandlers::ofByteArray;
            default -> HttpResponse.BodyHandlers::ofString;
        };
    }

    private <T> CompletionStage<RestResponse> execute(HttpRequest.Builder builder, Supplier<HttpResponse.BodyHandler<?>> handlerSupplier) {
        this.configuration.headers().forEach(builder::header);
        HttpRequest request = builder.build();
        RestClient.LOG.tracef("Request %s", (Object)request);
        if (this.authenticator != null && this.authenticator.supportsPreauthentication()) {
            this.authenticator.preauthenticate(builder);
        }
        return this.handle(this.httpClient.sendAsync(request, handlerSupplier.get()), handlerSupplier).thenApply(RestResponseJDK::new);
    }

    private <T> CompletionStage<HttpResponse<T>> handle(CompletionStage<HttpResponse<T>> response, Supplier<HttpResponse.BodyHandler<?>> handlerSupplier) {
        return response.thenCompose(r -> {
            if (r.statusCode() == 401 && this.authenticator != null) {
                CompletionStage authenticate = this.authenticator.authenticate(r, (HttpResponse.BodyHandler)handlerSupplier.get());
                if (authenticate == null) {
                    return CompletableFuture.completedFuture(r);
                }
                return this.handle(authenticate, handlerSupplier);
            }
            return CompletableFuture.completedFuture(r);
        });
    }

    @Override
    public void close() throws Exception {
        if (Runtime.version().compareTo(Runtime.Version.parse("21")) >= 0) {
            ((AutoCloseable)this.httpClient).close();
        }
        if (this.managedExecutorService) {
            this.executorService.shutdownNow();
        }
    }

    RestClientConfiguration getConfiguration() {
        return this.configuration;
    }
}

