/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.configuration.parsing.Schema;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.Attribute;
import org.infinispan.counter.configuration.CounterConfigurationBuilder;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.counter.configuration.Element;
import org.infinispan.counter.configuration.Reliability;
import org.infinispan.counter.configuration.StrongCounterConfigurationBuilder;
import org.infinispan.counter.configuration.WeakCounterConfigurationBuilder;
import org.infinispan.counter.logging.Log;

@Namespaces(value={@Namespace(root="counters"), @Namespace(uri="urn:infinispan:config:counters:*", root="counters", since="9.0")})
public class CounterConfigurationParser
implements ConfigurationParser {
    private static final Log log = (Log)LogFactory.getLog(CounterConfigurationParser.class, Log.class);

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        if (!holder.inScope((Enum)ParserScope.CACHE_CONTAINER)) {
            throw log.invalidScope(holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case COUNTERS: {
                this.parseCountersElement((XMLStreamReader)reader, (CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<AbstractCounterConfiguration> parseConfigurations(InputStream is) throws XMLStreamException {
        BufferedInputStream input = new BufferedInputStream(is);
        CounterManagerConfigurationBuilder builder = new CounterManagerConfigurationBuilder(null);
        try (XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(input);){
            reader.require(7, null, null);
            reader.nextTag();
            reader.require(1, null, null);
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case COUNTERS: {
                    this.parseCountersElement(reader, builder);
                    return builder.create().counters();
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
                }
            }
        }
    }

    private void parseCountersElement(XMLStreamReader reader, CounterManagerConfigurationBuilder builder) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NUM_OWNERS: {
                    builder.numOwner(Integer.parseInt(value));
                    continue block8;
                }
                case RELIABILITY: {
                    builder.reliability(Reliability.valueOf(value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STRONG_COUNTER: {
                    Schema schema = this.getSchema(reader);
                    if (!schema.since(10, 0)) {
                        this.parseStrongCounterLegacy(reader, builder.addStrongCounter());
                        continue block9;
                    }
                    this.parseStrongCounter(reader, builder.addStrongCounter());
                    continue block9;
                }
                case WEAK_COUNTER: {
                    this.parseWeakCounter(reader, builder.addWeakCounter());
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private Schema getSchema(XMLStreamReader reader) {
        String namespaceURI = reader.getNamespaceURI();
        if (namespaceURI == null) {
            return new Schema(Integer.parseInt(Version.getMajor()), Integer.parseInt(Version.getMinor()));
        }
        return Schema.fromNamespaceURI((String)namespaceURI);
    }

    private void parseWeakCounter(XMLStreamReader reader, WeakCounterConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONCURRENCY_LEVEL: {
                    builder.concurrencyLevel(Integer.parseInt(value));
                    continue block3;
                }
                default: {
                    this.parserCommonCounterAttributes(reader, builder, i, attribute, value);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseStrongCounterLegacy(XMLStreamReader reader, StrongCounterConfigurationBuilder builder) throws XMLStreamException {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parserCommonCounterAttributes(reader, builder, i, attribute, value);
        }
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case UPPER_BOUND: {
                    this.parseUpperBound(reader, builder);
                    continue block5;
                }
                case LOWER_BOUND: {
                    this.parseLowerBound(reader, builder);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseUpperBound(XMLStreamReader reader, StrongCounterConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    builder.upperBound(Long.parseLong(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseLowerBound(XMLStreamReader reader, StrongCounterConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    builder.lowerBound(Long.parseLong(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseStrongCounter(XMLStreamReader reader, StrongCounterConfigurationBuilder builder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case UPPER_BOUND: {
                    builder.upperBound(Long.parseLong(value));
                    continue block4;
                }
                case LOWER_BOUND: {
                    builder.lowerBound(Long.parseLong(value));
                    continue block4;
                }
                default: {
                    this.parserCommonCounterAttributes(reader, builder, i, attribute, value);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parserCommonCounterAttributes(XMLStreamReader reader, CounterConfigurationBuilder builder, int index, Attribute attribute, String value) throws XMLStreamException {
        switch (attribute) {
            case NAME: {
                builder.name(value);
                break;
            }
            case INITIAL_VALUE: {
                builder.initialValue(Long.parseLong(value));
                break;
            }
            case STORAGE: {
                builder.storage(Storage.valueOf((String)value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)index);
            }
        }
    }
}

