/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.Element;

public class StrongCounterConfiguration
extends AbstractCounterConfiguration {
    static final AttributeDefinition<Long> LOWER_BOUND = AttributeDefinition.builder((String)"lowerBound", (Object)Long.MIN_VALUE).immutable().build();
    static final AttributeDefinition<Long> UPPER_BOUND = AttributeDefinition.builder((String)"upperBound", (Object)Long.MAX_VALUE).immutable().build();
    static ElementDefinition<StrongCounterConfiguration> ELEMENT_DEFINITION = new DefaultElementDefinition(Element.STRONG_COUNTER.toString());

    StrongCounterConfiguration(AttributeSet attributes) {
        super(attributes);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(StrongCounterConfiguration.class, AbstractCounterConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{LOWER_BOUND, UPPER_BOUND});
    }

    public boolean isBound() {
        return this.attributes.attribute(LOWER_BOUND).isModified() || this.attributes.attribute(UPPER_BOUND).isModified();
    }

    public long lowerBound() {
        return (Long)this.attributes.attribute(LOWER_BOUND).get();
    }

    public long upperBound() {
        return (Long)this.attributes.attribute(UPPER_BOUND).get();
    }
}

