/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl;

import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.logging.Log;
import org.infinispan.functional.Param;

public final class Utils {
    private static final Log log = (Log)LogFactory.getLog(Utils.class, Log.class);

    private Utils() {
    }

    public static void validateStrongCounterBounds(long lowerBound, long initialValue, long upperBound) {
        if (lowerBound > initialValue || initialValue > upperBound) {
            throw log.invalidInitialValueForBoundedCounter(lowerBound, upperBound, initialValue);
        }
        if (lowerBound == upperBound) {
            throw log.invalidSameLowerAndUpperBound(lowerBound, upperBound);
        }
    }

    public static CounterState calculateState(long value, long lowerBound, long upperBound) {
        if (value < lowerBound) {
            return CounterState.LOWER_BOUND_REACHED;
        }
        if (value > upperBound) {
            return CounterState.UPPER_BOUND_REACHED;
        }
        return CounterState.VALID;
    }

    public static Param.PersistenceMode getPersistenceMode(Storage storage) {
        switch (storage) {
            case PERSISTENT: {
                return Param.PersistenceMode.LOAD_PERSIST;
            }
            case VOLATILE: {
                return Param.PersistenceMode.SKIP;
            }
        }
        throw new IllegalStateException("[should never happen] unknown storage " + storage);
    }
}

