/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.infinispan.counter.exception.CounterException;

public final class Util {
    private Util() {
    }

    private static CounterException rethrowAsCounterException(Throwable throwable) {
        if (throwable instanceof CounterException) {
            return (CounterException)throwable;
        }
        if (throwable instanceof ExecutionException || throwable instanceof CompletionException) {
            return Util.rethrowAsCounterException(throwable.getCause());
        }
        return new CounterException(throwable);
    }

    public static <T> T awaitCounterOperation(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Util.rethrowAsCounterException(e);
        }
        catch (ExecutionException e) {
            throw Util.rethrowAsCounterException(e);
        }
    }
}

