/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.weak;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.GuardedBy;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.SyncWeakCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.impl.SyncWeakCounterAdapter;
import org.infinispan.counter.impl.Util;
import org.infinispan.counter.impl.Utils;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.function.AddFunction;
import org.infinispan.counter.impl.function.CreateAndAddFunction;
import org.infinispan.counter.impl.function.ReadFunction;
import org.infinispan.counter.impl.function.RemoveFunction;
import org.infinispan.counter.impl.function.ResetFunction;
import org.infinispan.counter.impl.listener.CounterEventGenerator;
import org.infinispan.counter.impl.listener.CounterEventImpl;
import org.infinispan.counter.impl.listener.CounterManagerNotificationManager;
import org.infinispan.counter.impl.listener.TopologyChangeListener;
import org.infinispan.counter.impl.weak.WeakCounterKey;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadOnlyMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class WeakCounterImpl
implements WeakCounter,
CounterEventGenerator,
TopologyChangeListener {
    @GuardedBy(value="entries")
    private final Entry[] entries;
    private final AdvancedCache<WeakCounterKey, CounterValue> cache;
    private final FunctionalMap.ReadWriteMap<WeakCounterKey, CounterValue> readWriteMap;
    private final CounterManagerNotificationManager notificationManager;
    private final FunctionalMap.ReadOnlyMap<WeakCounterKey, CounterValue> readOnlyMap;
    private final CounterConfiguration configuration;
    private final CounterConfiguration zeroConfiguration;
    private final KeySelector selector;

    public WeakCounterImpl(String counterName, AdvancedCache<WeakCounterKey, CounterValue> cache, CounterConfiguration configuration, CounterManagerNotificationManager notificationManager) {
        this.cache = cache;
        this.notificationManager = notificationManager;
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create(cache).withParams(new Param[]{Utils.getPersistenceMode(configuration.storage())});
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
        this.readOnlyMap = ReadOnlyMapImpl.create((FunctionalMapImpl)functionalMap);
        this.entries = WeakCounterImpl.initKeys(counterName, configuration.concurrencyLevel());
        this.selector = cache.getCacheConfiguration().clustering().cacheMode().isClustered() ? new ClusteredKeySelector(this.entries) : new LocalKeySelector(this.entries);
        this.configuration = configuration;
        this.zeroConfiguration = CounterConfiguration.builder((CounterType)CounterType.WEAK).concurrencyLevel(configuration.concurrencyLevel()).storage(configuration.storage()).initialValue(0L).build();
    }

    private static <T> T get(int hash, T[] array) {
        return array[hash & array.length - 1];
    }

    private static Entry[] initKeys(String counterName, int concurrencyLevel) {
        ByteString name = ByteString.fromString((String)counterName);
        int size = org.infinispan.commons.util.Util.findNextHighestPowerOfTwo((int)concurrencyLevel);
        Entry[] entries = new Entry[size];
        for (int i = 0; i < size; ++i) {
            entries[i] = new Entry(new WeakCounterKey(name, i));
        }
        return entries;
    }

    public static void removeWeakCounter(Cache<WeakCounterKey, CounterValue> cache, CounterConfiguration configuration, String counterName) {
        ByteString counterNameByteString = ByteString.fromString((String)counterName);
        for (int i = 0; i < configuration.concurrencyLevel(); ++i) {
            cache.remove((Object)new WeakCounterKey(counterNameByteString, i));
        }
    }

    public void init() {
        this.registerListener();
        int i = 0;
        while (i < this.entries.length) {
            int index = i++;
            Util.awaitCounterOperation(this.readOnlyMap.eval((Object)this.entries[index].key, ReadFunction.getInstance()).thenAccept(value -> this.initEntry(index, (Long)value)));
        }
        this.selector.updatePreferredKeys();
    }

    public String getName() {
        return this.counterName().toString();
    }

    public long getValue() {
        Long snapshot = this.getCachedValue();
        return snapshot == null ? this.configuration.initialValue() : snapshot.longValue();
    }

    public CompletableFuture<Void> add(long delta) {
        WeakCounterKey key = this.findKey();
        return this.readWriteMap.eval((Object)key, new AddFunction(delta)).thenCompose(counterValue -> this.handleAddResult(key, (CounterValue)counterValue, delta));
    }

    public CompletableFuture<Void> reset() {
        int size = this.entries.length;
        CompletableFuture[] futures = new CompletableFuture[size];
        for (int i = 0; i < size; ++i) {
            futures[i] = this.readWriteMap.eval((Object)this.entries[i].key, ResetFunction.getInstance());
        }
        return CompletableFuture.allOf(futures);
    }

    public <T extends CounterListener> Handle<T> addListener(T listener) {
        return this.notificationManager.registerUserListener(this.counterName(), listener);
    }

    public CounterConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CounterEvent generate(CounterKey key, CounterValue value) {
        Entry[] entryArray = this.entries;
        synchronized (this.entries) {
            assert (key instanceof WeakCounterKey);
            int index = ((WeakCounterKey)key).getIndex();
            long newValue = value == null ? this.defaultValueOfIndex(index) : value.getValue();
            Long base = this.getCachedValue(index);
            Long oldValue = this.entries[index].update(newValue);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return base == null || oldValue == null || oldValue == newValue ? null : CounterEventImpl.create(base + oldValue, base + newValue);
        }
    }

    public CompletableFuture<Void> remove() {
        int size = this.entries.length;
        CompletableFuture[] futures = new CompletableFuture[size];
        for (int i = 0; i < size; ++i) {
            futures[i] = this.readWriteMap.eval((Object)this.entries[i].key, RemoveFunction.getInstance());
        }
        return CompletableFuture.allOf(futures);
    }

    public SyncWeakCounter sync() {
        return new SyncWeakCounterAdapter(this);
    }

    public void destroyAndRemove() {
        this.removeListener();
        Util.awaitCounterOperation(this.remove());
    }

    @Override
    public void topologyChanged() {
        this.selector.updatePreferredKeys();
    }

    public WeakCounterKey[] getPreferredKeys() {
        return this.selector.getPreferredKeys();
    }

    public WeakCounterKey[] getKeys() {
        WeakCounterKey[] keys = new WeakCounterKey[this.entries.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.entries[i].key;
        }
        return keys;
    }

    public String toString() {
        return "WeakCounter{counterName=" + this.counterName() + '}';
    }

    private long defaultValueOfIndex(int index) {
        return index == 0 ? this.configuration.initialValue() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEntry(int index, Long value) {
        if (value == null) {
            value = this.defaultValueOfIndex(index);
        }
        Entry[] entryArray = this.entries;
        synchronized (this.entries) {
            this.entries[index].init(value);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getCachedValue() {
        Entry[] entryArray = this.entries;
        synchronized (this.entries) {
            int index;
            long value = 0L;
            try {
                for (index = 0; index < this.entries.length; ++index) {
                    Long toAdd = this.entries[index].snapshot;
                    if (toAdd == null) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return null;
                    }
                    value = Math.addExact(value, toAdd);
                }
            }
            catch (ArithmeticException e) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.getCachedValue0(index, value, -1);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getCachedValue(int skipIndex) {
        Entry[] entryArray = this.entries;
        synchronized (this.entries) {
            int index;
            long value = 0L;
            try {
                for (index = 0; index < this.entries.length; ++index) {
                    if (index == skipIndex) continue;
                    Long toAdd = this.entries[index].snapshot;
                    if (toAdd == null) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return null;
                    }
                    value = Math.addExact(value, toAdd);
                }
            }
            catch (ArithmeticException e) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.getCachedValue0(index, value, skipIndex);
            }
            return value;
        }
    }

    private Long getCachedValue0(int index, long value, int skipIndex) {
        BigInteger currentValue = BigInteger.valueOf(value);
        do {
            Long toAdd;
            if ((toAdd = this.entries[index++].snapshot) == null) {
                return null;
            }
            currentValue = currentValue.add(BigInteger.valueOf(toAdd));
            if (index != skipIndex) continue;
            ++index;
        } while (index < this.entries.length);
        try {
            return currentValue.longValue();
        }
        catch (ArithmeticException e) {
            return currentValue.signum() > 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
    }

    private CompletableFuture<Void> handleAddResult(WeakCounterKey key, CounterValue value, long delta) {
        if (value == null) {
            CounterConfiguration createConfiguration = key.getIndex() == 0 ? this.configuration : this.zeroConfiguration;
            return this.readWriteMap.eval((Object)key, new CreateAndAddFunction(createConfiguration, delta)).thenApply(value1 -> null);
        }
        return CompletableFutures.completedNull();
    }

    private void registerListener() {
        this.notificationManager.registerCounter(this.counterName(), this, this);
    }

    private void removeListener() {
        this.notificationManager.removeCounter(this.counterName());
    }

    private WeakCounterKey findKey() {
        return this.selector.findKey((int)Thread.currentThread().getId());
    }

    private ByteString counterName() {
        return this.entries[0].key.getCounterName();
    }

    private class ClusteredKeySelector
    implements KeySelector {
        private final Entry[] entries;
        private volatile WeakCounterKey[] preferredKeys;

        private ClusteredKeySelector(Entry[] entries) {
            this.entries = entries;
        }

        @Override
        public WeakCounterKey findKey(int hash) {
            Object[] copy = this.preferredKeys;
            if (copy == null) {
                return ((Entry)WeakCounterImpl.get((int)hash, (Object[])this.entries)).key;
            }
            if (copy.length == 1) {
                return copy[0];
            }
            return (WeakCounterKey)WeakCounterImpl.get(hash, copy);
        }

        @Override
        public void updatePreferredKeys() {
            ArrayList<WeakCounterKey> preferredKeys = new ArrayList<WeakCounterKey>(this.entries.length);
            LocalizedCacheTopology topology = WeakCounterImpl.this.cache.getDistributionManager().getCacheTopology();
            for (Entry entry : this.entries) {
                if (!topology.getDistribution((Object)entry.key).isPrimary()) continue;
                preferredKeys.add(entry.key);
            }
            this.preferredKeys = preferredKeys.isEmpty() ? null : preferredKeys.toArray(new WeakCounterKey[preferredKeys.size()]);
        }

        @Override
        public WeakCounterKey[] getPreferredKeys() {
            return this.preferredKeys;
        }
    }

    private class LocalKeySelector
    implements KeySelector {
        private final Entry[] entries;

        private LocalKeySelector(Entry[] entries) {
            this.entries = entries;
        }

        @Override
        public WeakCounterKey findKey(int hash) {
            return ((Entry)WeakCounterImpl.get((int)hash, (Object[])this.entries)).key;
        }

        @Override
        public void updatePreferredKeys() {
        }

        @Override
        public WeakCounterKey[] getPreferredKeys() {
            return (WeakCounterKey[])Arrays.stream(this.entries).map(entry -> entry.key).toArray(WeakCounterKey[]::new);
        }
    }

    private static interface KeySelector {
        public WeakCounterKey findKey(int var1);

        public void updatePreferredKeys();

        public WeakCounterKey[] getPreferredKeys();
    }

    private static class Entry {
        final WeakCounterKey key;
        @GuardedBy(value="entries")
        volatile Long snapshot;

        private Entry(WeakCounterKey key) {
            this.key = key;
        }

        private void init(long initialValue) {
            if (this.snapshot == null) {
                this.snapshot = initialValue;
            }
        }

        private Long update(long value) {
            Long old = this.snapshot;
            this.snapshot = value;
            return old;
        }
    }
}

