/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriterImpl;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.CounterManagerConfiguration;
import org.infinispan.counter.configuration.Element;
import org.infinispan.counter.configuration.StrongCounterConfiguration;
import org.infinispan.counter.configuration.WeakCounterConfiguration;

public class CounterConfigurationSerializer
implements ConfigurationSerializer<CounterManagerConfiguration> {
    public void serialize(XMLExtendedStreamWriter writer, CounterManagerConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement((Enum)Element.COUNTERS);
        configuration.attributes().write((XMLStreamWriter)writer);
        this.writeConfigurations(writer, configuration.counters());
        writer.writeEndElement();
    }

    public void serializeConfigurations(OutputStream os, List<AbstractCounterConfiguration> configs) throws XMLStreamException {
        BufferedOutputStream output = new BufferedOutputStream(os);
        XMLStreamWriter subWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(output);
        XMLExtendedStreamWriterImpl writer = new XMLExtendedStreamWriterImpl(subWriter);
        writer.writeStartDocument();
        writer.writeStartElement((Enum)Element.COUNTERS);
        this.writeConfigurations((XMLExtendedStreamWriter)writer, configs);
        writer.writeEndElement();
        writer.writeEndDocument();
        subWriter.close();
    }

    private void writeConfigurations(XMLExtendedStreamWriter writer, List<AbstractCounterConfiguration> configs) throws XMLStreamException {
        for (AbstractCounterConfiguration c : configs) {
            if (c instanceof StrongCounterConfiguration) {
                this.writeStrongConfiguration((StrongCounterConfiguration)c, writer);
                continue;
            }
            if (!(c instanceof WeakCounterConfiguration)) continue;
            this.writeWeakConfiguration((WeakCounterConfiguration)c, writer);
        }
    }

    private void writeWeakConfiguration(WeakCounterConfiguration configuration, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement((Enum)Element.WEAK_COUNTER);
        configuration.attributes().write((XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeStrongConfiguration(StrongCounterConfiguration configuration, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement((Enum)Element.STRONG_COUNTER);
        configuration.attributes().write((XMLStreamWriter)writer);
        writer.writeEndElement();
    }
}

