/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.JsonReader;
import org.infinispan.commons.configuration.JsonWriter;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.configuration.serializer.AbstractConfigurationSerializerTest;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.CounterManagerConfiguration;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.counter.configuration.Reliability;
import org.infinispan.counter.configuration.StrongCounterConfiguration;
import org.infinispan.counter.configuration.StrongCounterConfigurationBuilder;
import org.infinispan.counter.configuration.WeakCounterConfiguration;
import org.infinispan.counter.configuration.WeakCounterConfigurationBuilder;
import org.infinispan.counter.exception.CounterConfigurationException;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="counter.ConfigurationSerializerTest")
@CleanupAfterMethod
public class ConfigurationSerializerTest
extends AbstractConfigurationSerializerTest {
    @DataProvider
    public static Object[][] configurationFiles() {
        return new Object[][]{{Paths.get("config/counters.xml", new String[0])}, {Paths.get("config/counters-9.4.xml", new String[0])}};
    }

    public void testParser() throws IOException {
        ConfigurationBuilderHolder holder = new ParserRegistry().parseFile("config/counters.xml");
        GlobalConfiguration globalConfiguration = holder.getGlobalConfigurationBuilder().build();
        CounterManagerConfiguration counterManagerConfiguration = (CounterManagerConfiguration)globalConfiguration.module(CounterManagerConfiguration.class);
        AssertJUnit.assertNotNull((Object)counterManagerConfiguration);
        AssertJUnit.assertEquals((int)3, (int)counterManagerConfiguration.numOwners());
        AssertJUnit.assertEquals((Object)Reliability.CONSISTENT, (Object)counterManagerConfiguration.reliability());
        HashMap<String, AbstractCounterConfiguration> counterConfig = new HashMap<String, AbstractCounterConfiguration>();
        for (AbstractCounterConfiguration configuration : counterManagerConfiguration.counters()) {
            counterConfig.put(configuration.name(), configuration);
        }
        this.assertStrongCounter("c1", (AbstractCounterConfiguration)counterConfig.get("c1"), 1L, Storage.PERSISTENT, false, Long.MIN_VALUE, Long.MAX_VALUE);
        this.assertStrongCounter("c2", (AbstractCounterConfiguration)counterConfig.get("c2"), 2L, Storage.VOLATILE, true, 0L, Long.MAX_VALUE);
        this.assertStrongCounter("c3", (AbstractCounterConfiguration)counterConfig.get("c3"), 3L, Storage.PERSISTENT, true, Long.MIN_VALUE, 5L);
        this.assertStrongCounter("c4", (AbstractCounterConfiguration)counterConfig.get("c4"), 4L, Storage.VOLATILE, true, 0L, 10L);
        this.assertWeakCounter((AbstractCounterConfiguration)counterConfig.get("c5"));
    }

    public void testInvalid() throws IOException {
        Exceptions.expectException(CacheConfigurationException.class, CounterConfigurationException.class, () -> new ParserRegistry().parseFile("config/invalid.xml"));
    }

    @Test(dataProvider="configurationFiles")
    public void jsonSerializationTest(Path config) throws Exception {
        JsonWriter jsonWriter = new JsonWriter();
        Properties properties = new Properties();
        properties.put("jboss.server.temp.dir", CommonsTestingUtil.tmpDirectory(ConfigurationSerializerTest.class));
        ParserRegistry registry = new ParserRegistry(Thread.currentThread().getContextClassLoader(), false, properties);
        URL url = FileLookupFactory.newInstance().lookupFileLocation(config.toString(), Thread.currentThread().getContextClassLoader());
        ConfigurationBuilderHolder holderBefore = registry.parse(url);
        CounterManagerConfigurationBuilder counterManagerConfigurationBuilder = (CounterManagerConfigurationBuilder)holderBefore.getGlobalConfigurationBuilder().modules().iterator().next();
        JsonReader jsonReader = new JsonReader();
        CounterManagerConfiguration confBefore = counterManagerConfigurationBuilder.create();
        List counters = confBefore.counters();
        for (AbstractCounterConfiguration beforeConf : counters) {
            StrongCounterConfiguration confAfter;
            StrongCounterConfigurationBuilder builder;
            String json = jsonWriter.toJSON((ConfigurationInfo)beforeConf);
            if (beforeConf instanceof StrongCounterConfiguration) {
                builder = new StrongCounterConfigurationBuilder(counterManagerConfigurationBuilder);
                jsonReader.readJson((ConfigurationBuilderInfo)builder, json);
                confAfter = builder.create();
                this.assertSameStrongCounterConfiguration((AbstractCounterConfiguration)confAfter, beforeConf);
            }
            if (!(beforeConf instanceof WeakCounterConfiguration)) continue;
            builder = new WeakCounterConfigurationBuilder(counterManagerConfigurationBuilder);
            jsonReader.readJson((ConfigurationBuilderInfo)builder, json);
            confAfter = builder.create();
            this.assertSameWeakCounterConfiguration((AbstractCounterConfiguration)confAfter, beforeConf);
        }
    }

    protected void compareExtraGlobalConfiguration(GlobalConfiguration configurationBefore, GlobalConfiguration configurationAfter) {
        CounterManagerConfiguration configBefore = (CounterManagerConfiguration)configurationBefore.module(CounterManagerConfiguration.class);
        CounterManagerConfiguration configAfter = (CounterManagerConfiguration)configurationAfter.module(CounterManagerConfiguration.class);
        AssertJUnit.assertEquals((int)configBefore.numOwners(), (int)configAfter.numOwners());
        AssertJUnit.assertEquals((Object)configBefore.reliability(), (Object)configAfter.reliability());
        HashMap<String, AbstractCounterConfiguration> counterConfigBefore = new HashMap<String, AbstractCounterConfiguration>();
        for (AbstractCounterConfiguration configuration : configBefore.counters()) {
            counterConfigBefore.put(configuration.name(), configuration);
        }
        HashMap<String, AbstractCounterConfiguration> counterConfigAfter = new HashMap<String, AbstractCounterConfiguration>();
        for (AbstractCounterConfiguration configuration : configAfter.counters()) {
            counterConfigAfter.put(configuration.name(), configuration);
        }
        this.assertSameStrongCounterConfiguration((AbstractCounterConfiguration)counterConfigBefore.get("c1"), (AbstractCounterConfiguration)counterConfigAfter.get("c1"));
        this.assertSameStrongCounterConfiguration((AbstractCounterConfiguration)counterConfigBefore.get("c2"), (AbstractCounterConfiguration)counterConfigAfter.get("c2"));
        this.assertSameStrongCounterConfiguration((AbstractCounterConfiguration)counterConfigBefore.get("c3"), (AbstractCounterConfiguration)counterConfigAfter.get("c3"));
        this.assertSameStrongCounterConfiguration((AbstractCounterConfiguration)counterConfigBefore.get("c4"), (AbstractCounterConfiguration)counterConfigAfter.get("c4"));
        this.assertSameWeakCounterConfiguration((AbstractCounterConfiguration)counterConfigBefore.get("c5"), (AbstractCounterConfiguration)counterConfigAfter.get("c5"));
    }

    private void assertSameStrongCounterConfiguration(AbstractCounterConfiguration c1, AbstractCounterConfiguration c2) {
        AssertJUnit.assertTrue((boolean)(c1 instanceof StrongCounterConfiguration));
        AssertJUnit.assertTrue((boolean)(c2 instanceof StrongCounterConfiguration));
        AssertJUnit.assertEquals((String)c1.name(), (String)c2.name());
        AssertJUnit.assertEquals((long)c1.initialValue(), (long)c2.initialValue());
        AssertJUnit.assertEquals((Object)c1.storage(), (Object)c2.storage());
        AssertJUnit.assertEquals((boolean)((StrongCounterConfiguration)c1).isBound(), (boolean)((StrongCounterConfiguration)c2).isBound());
        AssertJUnit.assertEquals((long)((StrongCounterConfiguration)c1).lowerBound(), (long)((StrongCounterConfiguration)c2).lowerBound());
        AssertJUnit.assertEquals((long)((StrongCounterConfiguration)c1).upperBound(), (long)((StrongCounterConfiguration)c2).upperBound());
    }

    private void assertSameWeakCounterConfiguration(AbstractCounterConfiguration c1, AbstractCounterConfiguration c2) {
        AssertJUnit.assertTrue((boolean)(c1 instanceof WeakCounterConfiguration));
        AssertJUnit.assertTrue((boolean)(c2 instanceof WeakCounterConfiguration));
        AssertJUnit.assertEquals((String)c1.name(), (String)c2.name());
        AssertJUnit.assertEquals((long)c1.initialValue(), (long)c2.initialValue());
        AssertJUnit.assertEquals((Object)c1.storage(), (Object)c2.storage());
        AssertJUnit.assertEquals((int)((WeakCounterConfiguration)c1).concurrencyLevel(), (int)((WeakCounterConfiguration)c2).concurrencyLevel());
    }

    private void assertWeakCounter(AbstractCounterConfiguration configuration) {
        AssertJUnit.assertTrue((boolean)(configuration instanceof WeakCounterConfiguration));
        AssertJUnit.assertEquals((String)"c5", (String)configuration.name());
        AssertJUnit.assertEquals((long)5L, (long)configuration.initialValue());
        AssertJUnit.assertEquals((Object)Storage.PERSISTENT, (Object)configuration.storage());
        AssertJUnit.assertEquals((int)1, (int)((WeakCounterConfiguration)configuration).concurrencyLevel());
    }

    private void assertStrongCounter(String name, AbstractCounterConfiguration configuration, long initialValue, Storage storage, boolean bound, long lowerBound, long upperBound) {
        AssertJUnit.assertTrue((boolean)(configuration instanceof StrongCounterConfiguration));
        AssertJUnit.assertEquals((String)name, (String)configuration.name());
        AssertJUnit.assertEquals((long)initialValue, (long)configuration.initialValue());
        AssertJUnit.assertEquals((Object)storage, (Object)configuration.storage());
        AssertJUnit.assertEquals((boolean)bound, (boolean)((StrongCounterConfiguration)configuration).isBound());
        AssertJUnit.assertEquals((long)lowerBound, (long)((StrongCounterConfiguration)configuration).lowerBound());
        AssertJUnit.assertEquals((long)upperBound, (long)((StrongCounterConfiguration)configuration).upperBound());
    }
}

