/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.manager;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.context.Flag;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.PropertyFormatter;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.impl.Util;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.listener.CounterManagerNotificationManager;
import org.infinispan.counter.impl.manager.CounterConfigurationManager;
import org.infinispan.counter.impl.manager.CounterConfigurationStorage;
import org.infinispan.counter.impl.manager.PersistedCounterConfigurationStorage;
import org.infinispan.counter.impl.manager.SecurityActions;
import org.infinispan.counter.impl.manager.VolatileCounterConfigurationStorage;
import org.infinispan.counter.impl.strong.AbstractStrongCounter;
import org.infinispan.counter.impl.strong.BoundedStrongCounter;
import org.infinispan.counter.impl.strong.UnboundedStrongCounter;
import org.infinispan.counter.impl.weak.WeakCounterImpl;
import org.infinispan.counter.logging.Log;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.manager.EmbeddedCacheManager;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="CounterManager", description="Component to manage counters")
public class EmbeddedCounterManager
implements CounterManager {
    public static final String OBJECT_NAME = "CounterManager";
    private static final Log log = (Log)LogFactory.getLog(EmbeddedCounterManager.class, Log.class);
    private final Map<String, Object> counters;
    private final EmbeddedCacheManager cacheManager;
    private final CounterConfigurationManager configurationManager;
    private volatile AdvancedCache<CounterKey, CounterValue> counterCache;
    private volatile boolean started;
    @Inject
    CounterManagerNotificationManager notificationManager;

    public EmbeddedCounterManager(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.counters = new ConcurrentHashMap<String, Object>(32);
        CounterConfigurationStorage storage = EmbeddedCounterManager.isGlobalStateEnabled(cacheManager) ? new PersistedCounterConfigurationStorage() : new VolatileCounterConfigurationStorage();
        storage.initialize(cacheManager);
        this.configurationManager = new CounterConfigurationManager(cacheManager, storage);
    }

    private static boolean isGlobalStateEnabled(EmbeddedCacheManager cacheManager) {
        return SecurityActions.getCacheManagerConfiguration(cacheManager).globalState().enabled();
    }

    @Start
    public void start() {
        if (log.isTraceEnabled()) {
            log.trace("Starting EmbeddedCounterManager");
        }
        this.configurationManager.start();
        this.started = true;
    }

    @Stop(priority=9)
    public void stop() {
        if (log.isTraceEnabled()) {
            log.trace("Stopping EmbeddedCounterManager");
        }
        this.started = false;
        this.counterCache = null;
        this.configurationManager.stop();
    }

    private static <T> T validateCounter(Class<T> tClass, Object retVal) {
        Class<?> rClass = retVal.getClass();
        if (tClass.isAssignableFrom(rClass)) {
            return tClass.cast(retVal);
        }
        throw Log.CONTAINER.invalidCounterType(tClass.getSimpleName(), rClass.getSimpleName());
    }

    @ManagedOperation(description="Removes the counter's value from the cluster. The counter will be re-created when access next time.", displayName="Remove Counter", name="remove")
    public void remove(String counterName) {
        this.removeCounter(counterName, true);
    }

    private void removeCounter(String counterName, boolean keepConfig) {
        CounterConfiguration configuration = this.getConfiguration(counterName);
        if (configuration == null) {
            return;
        }
        this.counters.compute(counterName, (name, counter) -> {
            this.removeCounter((String)name, counter, configuration);
            if (!keepConfig) {
                Util.awaitCounterOperation(this.configurationManager.removeConfiguration((String)name));
            }
            return null;
        });
    }

    public void undefineCounter(String counterName) {
        this.removeCounter(counterName, false);
    }

    public StrongCounter getStrongCounter(String name) {
        this.checkStarted();
        Object counter = this.counters.computeIfAbsent(name, this::createCounter);
        return EmbeddedCounterManager.validateCounter(StrongCounter.class, counter);
    }

    public StrongCounter getCreatedStrongCounter(String name) {
        this.checkStarted();
        Object counter = this.counters.get(name);
        if (counter == null) {
            return null;
        }
        return EmbeddedCounterManager.validateCounter(StrongCounter.class, counter);
    }

    public WeakCounter getWeakCounter(String name) {
        this.checkStarted();
        Object counter = this.counters.computeIfAbsent(name, this::createCounter);
        return EmbeddedCounterManager.validateCounter(WeakCounter.class, counter);
    }

    public WeakCounter getCreatedWeakCounter(String name) {
        this.checkStarted();
        Object counter = this.counters.get(name);
        if (counter == null) {
            return null;
        }
        return EmbeddedCounterManager.validateCounter(WeakCounter.class, counter);
    }

    @ManagedOperation(description="Returns a collection of defined counter's name.", displayName="Get Defined Counters", name="counters")
    public Collection<String> getCounterNames() {
        return this.configurationManager.getCounterNames();
    }

    public CompletableFuture<Boolean> defineCounterAsync(String name, CounterConfiguration configuration) {
        return this.configurationManager.defineConfiguration(name, configuration);
    }

    public boolean defineCounter(String name, CounterConfiguration configuration) {
        return Util.awaitCounterOperation(this.defineCounterAsync(name, configuration));
    }

    public boolean isDefined(String name) {
        return Util.awaitCounterOperation(this.isDefinedAsync(name));
    }

    public CounterConfiguration getConfiguration(String counterName) {
        return Util.awaitCounterOperation(this.getConfigurationAsync(counterName));
    }

    public CompletableFuture<CounterConfiguration> getConfigurationAsync(String name) {
        return this.configurationManager.getConfiguration(name);
    }

    private StrongCounter createBoundedStrongCounter(String counterName, CounterConfiguration configuration) {
        BoundedStrongCounter counter = new BoundedStrongCounter(counterName, this.cache(configuration), configuration, this.notificationManager);
        counter.init();
        return counter;
    }

    @ManagedOperation(description="Returns the current counter's value", displayName="Get Counter' Value", name="value")
    public long getValue(String counterName) {
        CounterConfiguration configuration = this.getConfiguration(counterName);
        if (configuration == null) {
            throw Log.CONTAINER.undefinedCounter(counterName);
        }
        if (configuration.type() == CounterType.WEAK) {
            return this.getWeakCounter(counterName).getValue();
        }
        return (Long)Util.awaitCounterOperation(this.getStrongCounter(counterName).getValue());
    }

    @ManagedOperation(description="Resets the counter's value", displayName="Reset Counter", name="reset")
    public void reset(String counterName) {
        CounterConfiguration configuration = this.getConfiguration(counterName);
        if (configuration == null) {
            throw Log.CONTAINER.undefinedCounter(counterName);
        }
        if (configuration.type() == CounterType.WEAK) {
            Util.awaitCounterOperation(this.getWeakCounter(counterName).reset());
        } else {
            Util.awaitCounterOperation(this.getStrongCounter(counterName).reset());
        }
    }

    @ManagedOperation(description="Returns the counter's configuration", displayName="Counter Configuration", name="configuration")
    public Properties getCounterConfiguration(String counterName) {
        CounterConfiguration configuration = this.getConfiguration(counterName);
        if (configuration == null) {
            throw Log.CONTAINER.undefinedCounter(counterName);
        }
        return PropertyFormatter.getInstance().format(configuration);
    }

    private StrongCounter createUnboundedStrongCounter(String counterName, CounterConfiguration configuration) {
        UnboundedStrongCounter counter = new UnboundedStrongCounter(counterName, this.cache(configuration), configuration, this.notificationManager);
        counter.init();
        return counter;
    }

    private WeakCounter createWeakCounter(String counterName, CounterConfiguration configuration) {
        WeakCounterImpl counter = new WeakCounterImpl(counterName, this.cache(configuration), configuration, this.notificationManager);
        counter.init();
        return counter;
    }

    public CompletableFuture<Boolean> isDefinedAsync(String name) {
        return this.getConfigurationAsync(name).thenApply(Objects::nonNull);
    }

    private synchronized void assertCounterCacheCreated() {
        if (this.started && this.counterCache == null) {
            this.counterCache = this.cacheManager.getCache("org.infinispan.COUNTER").getAdvancedCache();
        }
    }

    private <K extends CounterKey> AdvancedCache<K, CounterValue> cache() {
        this.assertCounterCacheCreated();
        return this.counterCache;
    }

    private <K extends CounterKey> AdvancedCache<K, CounterValue> cache(CounterConfiguration configuration) {
        return configuration.storage() == Storage.VOLATILE ? this.cache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE}) : this.cache();
    }

    private void removeCounter(String name, Object counter, CounterConfiguration configuration) {
        if (configuration.type() == CounterType.WEAK) {
            if (counter == null) {
                WeakCounterImpl.removeWeakCounter(this.cache(), configuration, name);
            } else {
                ((WeakCounterImpl)counter).destroyAndRemove();
            }
        } else if (counter == null) {
            AbstractStrongCounter.removeStrongCounter(this.cache(), name);
        } else {
            ((AbstractStrongCounter)counter).destroyAndRemove();
        }
    }

    private void checkStarted() {
        if (!this.started) {
            throw Log.CONTAINER.managerNotStarted();
        }
    }

    private Object createCounter(String counterName) {
        CounterConfiguration configuration = this.getConfiguration(counterName);
        if (configuration == null) {
            throw Log.CONTAINER.undefinedCounter(counterName);
        }
        switch (configuration.type()) {
            case WEAK: {
                this.notificationManager.registerTopologyListener((Cache<? extends CounterKey, CounterValue>)this.cache());
                this.notificationManager.registerCounterValueListener((Cache<? extends CounterKey, CounterValue>)this.cache());
                return this.createWeakCounter(counterName, configuration);
            }
            case BOUNDED_STRONG: {
                return this.createBoundedStrongCounter(counterName, configuration);
            }
            case UNBOUNDED_STRONG: {
                return this.createUnboundedStrongCounter(counterName, configuration);
            }
        }
        throw new IllegalStateException("[should never happen] unknown counter type: " + configuration.type());
    }
}

