package org.infinispan.counter.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.util.ByteString;
import org.infinispan.counter.exception.CounterConfigurationException;
import java.lang.String;
import org.infinispan.counter.exception.CounterNotFoundException;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.infinispan.counter.exception.CounterException;
import java.util.Arrays;
import java.io.File;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-02-15T12:30:45-0500")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String missingCounterName$str() {
        return "ISPN029503: The counter name is missing.";
    }
    @Override
    public final CounterConfigurationException missingCounterName() {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), missingCounterName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidStorageMode$str() {
        return "ISPN029504: Invalid storage mode. It must be non-null";
    }
    @Override
    public final CounterConfigurationException invalidStorageMode() {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidStorageMode$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPersistentStorageMode$str() {
        return "ISPN029505: Invalid storage mode. PERSISTENT is not allowed without global state enabled in cache container.";
    }
    @Override
    public final CounterConfigurationException invalidPersistentStorageMode() {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidPersistentStorageMode$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNumOwners$str() {
        return "ISPN029506: Invalid number of owner. It must be higher than zero but it was %s";
    }
    @Override
    public final CounterConfigurationException invalidNumOwners(final int value) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidNumOwners$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidReliabilityMode$str() {
        return "ISPN029507: Invalid reliability mode. It must be non-null";
    }
    @Override
    public final CounterConfigurationException invalidReliabilityMode() {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidReliabilityMode$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidInitialValueForBoundedCounter$str() {
        return "ISPN029508: Invalid initial value for counter. It must be between %s and %s (inclusive) but was %s";
    }
    @Override
    public final CounterConfigurationException invalidInitialValueForBoundedCounter(final long lower, final long upper, final long value) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidInitialValueForBoundedCounter$str(), lower, upper, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidConcurrencyLevel$str() {
        return "ISPN029509: Invalid concurrency-level. It must be higher than zero but it was %s";
    }
    @Override
    public final CounterConfigurationException invalidConcurrencyLevel(final int value) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidConcurrencyLevel$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCounterType$str() {
        return "ISPN029514: Invalid counter type. Expected=%s but got %s";
    }
    @Override
    public final CounterException invalidCounterType(final String expected, final String actual) {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), invalidCounterType$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String undefinedCounter$str() {
        return "ISPN029516: Counter '%s' is not defined.";
    }
    @Override
    public final CounterNotFoundException undefinedCounter(final String name) {
        final CounterNotFoundException result = new CounterNotFoundException(String.format(getLoggingLocale(), undefinedCounter$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicatedCounterName$str() {
        return "ISPN029517: Duplicated counter name found. Counter '%s' already exists.";
    }
    @Override
    public final CounterConfigurationException duplicatedCounterName(final String counter) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), duplicatedCounterName$str(), counter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String metadataIsMissing$str() {
        return "ISPN029518: Metadata not found but counter exists. Counter=%s";
    }
    @Override
    public final IllegalStateException metadataIsMissing(final ByteString counterName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), metadataIsMissing$str(), counterName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidScope$str() {
        return "ISPN029520: Invalid scope for tag <counter>. Expected CACHE_CONTAINER but was %s";
    }
    @Override
    public final CounterConfigurationException invalidScope(final String scope) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidScope$str(), scope));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSameLowerAndUpperBound$str() {
        return "ISPN029524: Lower bound (%s) and upper bound (%s) can't be the same.";
    }
    @Override
    public final CounterConfigurationException invalidSameLowerAndUpperBound(final long lower, final long upper) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidSameLowerAndUpperBound$str(), lower, upper));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotRenamePersistentFile$str() {
        return "ISPN029525: Cannot rename file %s to %s";
    }
    @Override
    public final CounterConfigurationException cannotRenamePersistentFile(final String absolutePath, final File persistentFile, final Throwable cause) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), cannotRenamePersistentFile$str(), absolutePath, persistentFile), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorPersistingCountersConfiguration$str() {
        return "ISPN029526: Error while persisting counter's configurations";
    }
    @Override
    public final CounterConfigurationException errorPersistingCountersConfiguration(final Throwable cause) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), errorPersistingCountersConfiguration$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorReadingCountersConfiguration$str() {
        return "ISPN029527: Error while reading counter's configurations";
    }
    @Override
    public final CounterConfigurationException errorReadingCountersConfiguration(final Throwable cause) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), errorReadingCountersConfiguration$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String counterManagerNotStarted$str() {
        return "ISPN029528: CounterManager hasn't started yet or has been stopped.";
    }
    @Override
    public final CounterException counterManagerNotStarted() {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), counterManagerNotStarted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String jmxRegistrationFailed$str() {
        return "ISPN029529: MBean registration failed";
    }
    @Override
    public final CounterException jmxRegistrationFailed(final Throwable cause) {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), jmxRegistrationFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
