/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.strong;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.GuardedBy;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.SyncStrongCounter;
import org.infinispan.counter.impl.SyncStrongCounterAdapter;
import org.infinispan.counter.impl.Util;
import org.infinispan.counter.impl.Utils;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.function.AddFunction;
import org.infinispan.counter.impl.function.CompareAndSwapFunction;
import org.infinispan.counter.impl.function.CreateAndAddFunction;
import org.infinispan.counter.impl.function.CreateAndCASFunction;
import org.infinispan.counter.impl.function.CreateAndSetFunction;
import org.infinispan.counter.impl.function.ReadFunction;
import org.infinispan.counter.impl.function.RemoveFunction;
import org.infinispan.counter.impl.function.ResetFunction;
import org.infinispan.counter.impl.function.SetFunction;
import org.infinispan.counter.impl.listener.CounterEventGenerator;
import org.infinispan.counter.impl.listener.CounterEventImpl;
import org.infinispan.counter.impl.listener.CounterManagerNotificationManager;
import org.infinispan.counter.impl.manager.InternalCounterAdmin;
import org.infinispan.counter.impl.strong.StrongCounterKey;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadOnlyMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;

public abstract class AbstractStrongCounter
implements StrongCounter,
CounterEventGenerator,
InternalCounterAdmin {
    final StrongCounterKey key;
    private final FunctionalMap.ReadWriteMap<StrongCounterKey, CounterValue> readWriteMap;
    private final FunctionalMap.ReadOnlyMap<StrongCounterKey, CounterValue> readOnlyMap;
    private final CounterManagerNotificationManager notificationManager;
    private final CounterConfiguration configuration;
    @GuardedBy(value="this")
    private CounterValue weakCounter;

    AbstractStrongCounter(String counterName, AdvancedCache<StrongCounterKey, CounterValue> cache, CounterConfiguration configuration, CounterManagerNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create(cache).withParams(new Param[]{Utils.getPersistenceMode(configuration.storage())});
        this.key = new StrongCounterKey(counterName);
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
        this.readOnlyMap = ReadOnlyMapImpl.create((FunctionalMapImpl)functionalMap);
        this.weakCounter = null;
        this.configuration = configuration;
    }

    public static CompletionStage<Void> removeStrongCounter(Cache<StrongCounterKey, CounterValue> cache, String counterName) {
        return cache.removeAsync((Object)new StrongCounterKey(counterName)).thenApply(CompletableFutures.toNullFunction());
    }

    public final CompletionStage<InternalCounterAdmin> init() {
        this.registerListener();
        return ((CompletableFuture)this.readOnlyMap.eval((Object)this.key, ReadFunction.getInstance()).thenAccept(this::initCounterState)).thenApply(unused -> this);
    }

    @Override
    public StrongCounter asStrongCounter() {
        return this;
    }

    @Override
    public CompletionStage<Void> destroy() {
        this.removeListener();
        return this.remove();
    }

    @Override
    public CompletionStage<Long> value() {
        return this.getValue();
    }

    @Override
    public boolean isWeakCounter() {
        return false;
    }

    public final String getName() {
        return this.key.getCounterName().toString();
    }

    public final CompletableFuture<Long> getValue() {
        return this.readOnlyMap.eval((Object)this.key, ReadFunction.getInstance()).thenApply(this::handleReadResult);
    }

    public final CompletableFuture<Long> addAndGet(long delta) {
        return this.readWriteMap.eval((Object)this.key, new AddFunction(delta)).thenCompose(value -> this.checkAddResult((CounterValue)value, delta));
    }

    public final CompletableFuture<Void> reset() {
        return this.readWriteMap.eval((Object)this.key, ResetFunction.getInstance());
    }

    public final <T extends CounterListener> Handle<T> addListener(T listener) {
        Util.awaitCounterOperation(this.notificationManager.registerCounterValueListener((Cache<? extends CounterKey, CounterValue>)this.readWriteMap.cache()));
        return this.notificationManager.registerUserListener(this.key.getCounterName(), listener);
    }

    public CompletableFuture<Long> compareAndSwap(long expect, long update) {
        return this.readWriteMap.eval((Object)this.key, new CompareAndSwapFunction(expect, update)).thenCompose(result -> this.checkCasResult(result, expect, update));
    }

    public CompletableFuture<Long> getAndSet(long value) {
        return this.readWriteMap.eval((Object)this.key, new SetFunction(value)).thenCompose(result -> this.checkSetResult(result, value));
    }

    @Override
    public synchronized CounterEvent generate(CounterKey key, CounterValue value) {
        CounterValue newValue;
        CounterValue counterValue = newValue = value == null ? CounterValue.newCounterValue(this.configuration) : value;
        if (this.weakCounter == null || this.weakCounter.equals(newValue)) {
            this.weakCounter = newValue;
            return null;
        }
        CounterEvent event = CounterEventImpl.create(this.weakCounter, newValue);
        this.weakCounter = newValue;
        return event;
    }

    public CompletableFuture<Void> remove() {
        return this.readWriteMap.eval((Object)this.key, RemoveFunction.getInstance());
    }

    public final CounterConfiguration getConfiguration() {
        return this.configuration;
    }

    public SyncStrongCounter sync() {
        return new SyncStrongCounterAdapter(this);
    }

    protected abstract Long handleCASResult(Object var1);

    protected abstract long handleAddResult(CounterValue var1);

    protected abstract Long handleSetResult(Object var1);

    private void registerListener() {
        this.notificationManager.registerCounter(this.key.getCounterName(), this, null);
    }

    private void removeListener() {
        this.notificationManager.removeCounter(this.key.getCounterName());
    }

    private synchronized void initCounterState(Long currentValue) {
        if (this.weakCounter == null) {
            this.weakCounter = currentValue == null ? CounterValue.newCounterValue(this.configuration) : CounterValue.newCounterValue((long)currentValue, this.configuration);
        }
    }

    private long handleReadResult(Long value) {
        return value == null ? this.configuration.initialValue() : value.longValue();
    }

    private CompletableFuture<Long> checkAddResult(CounterValue value, long delta) {
        if (value == null) {
            return this.readWriteMap.eval((Object)this.key, new CreateAndAddFunction(this.configuration, delta)).thenApply(this::handleAddResult);
        }
        return CompletableFuture.completedFuture(this.handleAddResult(value));
    }

    private CompletionStage<Long> checkCasResult(Object result, long expect, long update) {
        if (result == null) {
            return this.readWriteMap.eval((Object)this.key, new CreateAndCASFunction(this.configuration, expect, update)).thenApply(this::handleCASResult);
        }
        return CompletableFuture.completedFuture(this.handleCASResult(result));
    }

    private CompletionStage<Long> checkSetResult(Object result, long update) {
        if (result == null) {
            return this.readWriteMap.eval((Object)this.key, new CreateAndSetFunction(this.configuration, update)).thenApply(this::handleSetResult);
        }
        return CompletableFuture.completedFuture(this.handleSetResult(result));
    }
}

