/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.logging;

import java.io.File;
import org.infinispan.counter.exception.CounterConfigurationException;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.counter.exception.CounterNotFoundException;
import org.infinispan.util.ByteString;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    public static final String LOG_ROOT = "org.infinispan.";
    public static final Log CONTAINER = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.CONTAINER");

    @Message(value="The counter name is missing.", id=29503)
    public CounterConfigurationException missingCounterName();

    @Message(value="Invalid storage mode. It must be non-null", id=29504)
    public CounterConfigurationException invalidStorageMode();

    @Message(value="Invalid storage mode. PERSISTENT is not allowed without global state enabled in cache container.", id=29505)
    public CounterConfigurationException invalidPersistentStorageMode();

    @Message(value="Invalid number of owner. It must be higher than zero but it was %s", id=29506)
    public CounterConfigurationException invalidNumOwners(int var1);

    @Message(value="Invalid reliability mode. It must be non-null", id=29507)
    public CounterConfigurationException invalidReliabilityMode();

    @Message(value="Invalid initial value for counter. It must be between %s and %s (inclusive) but was %s", id=29508)
    public CounterConfigurationException invalidInitialValueForBoundedCounter(long var1, long var3, long var5);

    @Message(value="Invalid concurrency-level. It must be higher than zero but it was %s", id=29509)
    public CounterConfigurationException invalidConcurrencyLevel(int var1);

    @Message(value="Invalid counter type. Expected=%s but got %s", id=29514)
    public CounterException invalidCounterType(String var1, String var2);

    @Message(value="Counter '%s' is not defined.", id=29516)
    public CounterNotFoundException undefinedCounter(String var1);

    @Message(value="Duplicated counter name found. Counter '%s' already exists.", id=29517)
    public CounterConfigurationException duplicatedCounterName(String var1);

    @Message(value="Metadata not found but counter exists. Counter=%s", id=29518)
    public IllegalStateException metadataIsMissing(ByteString var1);

    @Message(value="Invalid scope for tag <counter>. Expected CACHE_CONTAINER but was %s", id=29520)
    public CounterConfigurationException invalidScope(String var1);

    @Message(value="Lower bound (%s) and upper bound (%s) can't be the same.", id=29524)
    public CounterConfigurationException invalidSameLowerAndUpperBound(long var1, long var3);

    @Message(value="Cannot rename file %s to %s", id=29525)
    public CounterConfigurationException cannotRenamePersistentFile(String var1, File var2, @Cause Throwable var3);

    @Message(value="Error while persisting counter's configurations", id=29526)
    public CounterConfigurationException errorPersistingCountersConfiguration(@Cause Throwable var1);

    @Message(value="Error while reading counter's configurations", id=29527)
    public CounterConfigurationException errorReadingCountersConfiguration(@Cause Throwable var1);

    @Message(value="CounterManager hasn't started yet or has been stopped.", id=29528)
    public CounterException counterManagerNotStarted();

    @Message(value="MBean registration failed", id=29529)
    public CounterException jmxRegistrationFailed(@Cause Throwable var1);
}

