/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.Attribute;
import org.infinispan.counter.configuration.CounterConfigurationBuilder;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.counter.configuration.WeakCounterConfigurationBuilder;
import org.infinispan.counter.logging.Log;

public class WeakCounterConfiguration
extends AbstractCounterConfiguration {
    static final AttributeDefinition<Integer> CONCURRENCY_LEVEL = AttributeDefinition.builder((Enum)Attribute.CONCURRENCY_LEVEL, (Object)16).validator(value -> {
        if (value < 1) {
            throw Log.CONTAINER.invalidConcurrencyLevel((int)value);
        }
    }).immutable().build();

    WeakCounterConfiguration(AttributeSet attributes) {
        super(attributes);
    }

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(WeakCounterConfiguration.class, AbstractCounterConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{CONCURRENCY_LEVEL});
    }

    public int concurrencyLevel() {
        return (Integer)this.attributes.attribute(CONCURRENCY_LEVEL).get();
    }

    @Override
    CounterConfigurationBuilder<?, ?> toBuilder(CounterManagerConfigurationBuilder manager) {
        WeakCounterConfigurationBuilder builder = new WeakCounterConfigurationBuilder(manager);
        builder.attributes.read(this.attributes, Combine.DEFAULT);
        return builder;
    }
}

