/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.function;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.MetaParam;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.exts.NoStateExternalizer;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.externalizers.ExternalizerIds;
import org.infinispan.counter.impl.function.BaseFunction;
import org.infinispan.counter.impl.metadata.ConfigurationMetadata;
import org.infinispan.counter.logging.Log;
import org.infinispan.util.ByteString;

public class ResetFunction<K extends CounterKey>
extends BaseFunction<K, Void> {
    public static final AdvancedExternalizer<ResetFunction> EXTERNALIZER = new Externalizer();
    private static final Log log = (Log)LogFactory.getLog(ResetFunction.class, Log.class);
    private static final ResetFunction INSTANCE = new ResetFunction();

    private ResetFunction() {
    }

    public static <K extends CounterKey> ResetFunction<K> getInstance() {
        return INSTANCE;
    }

    @Override
    void logCounterNotFound(ByteString counterName) {
        log.noSuchCounterReset(counterName);
    }

    @Override
    Void apply(EntryView.ReadWriteEntryView<K, CounterValue> entryView, ConfigurationMetadata metadata) {
        entryView.set((Object)CounterValue.newCounterValue(metadata.get()), new MetaParam.Writable[]{metadata});
        return null;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    public String toString() {
        return "ResetFunction{}";
    }

    private static class Externalizer
    extends NoStateExternalizer<ResetFunction> {
        private Externalizer() {
        }

        public ResetFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return ResetFunction.getInstance();
        }

        public Set<Class<? extends ResetFunction>> getTypeClasses() {
            return Collections.singleton(ResetFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.RESET_FUNCTION;
        }
    }
}

