/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.impl.BaseCounterTest;
import org.infinispan.counter.util.TestCounter;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractCounterNotificationTest
extends BaseCounterTest {
    private static final int CLUSTER_SIZE = 4;

    public void testSimpleListener(Method method) throws Exception {
        String counterName = method.getName();
        TestCounter[] counters = new TestCounter[4];
        for (int i = 0; i < 4; ++i) {
            counters[i] = this.createCounter(this.counterManager(i), counterName);
        }
        Handle<ListenerQueue> l = counters[0].addListener(new ListenerQueue());
        for (TestCounter counter : counters) {
            counter.increment();
        }
        ListenerQueue lq = (ListenerQueue)l.getCounterListener();
        this.printQueue(lq);
        lq.assertEvent(0L, CounterState.VALID, 1L, CounterState.VALID);
        lq.assertEvent(1L, CounterState.VALID, 2L, CounterState.VALID);
        lq.assertEvent(2L, CounterState.VALID, 3L, CounterState.VALID);
        lq.assertEvent(3L, CounterState.VALID, 4L, CounterState.VALID);
        AssertJUnit.assertEquals((long)4L, (long)counters[0].getValue());
        l.remove();
        for (TestCounter counter : counters) {
            counter.increment();
        }
        AssertJUnit.assertTrue((boolean)((ListenerQueue)l.getCounterListener()).queue.isEmpty());
    }

    public void testMultipleListeners(Method method) throws ExecutionException, InterruptedException {
        String counterName = method.getName();
        TestCounter[] counters = new TestCounter[4];
        ArrayList<Handle<ListenerQueue>> listeners = new ArrayList<Handle<ListenerQueue>>(4);
        for (int i = 0; i < 4; ++i) {
            counters[i] = this.createCounter(this.counterManager(i), counterName);
            listeners.add(counters[i].addListener(new ListenerQueue()));
        }
        for (TestCounter counter : counters) {
            counter.increment();
        }
        for (int i = 0; i < 4; ++i) {
            ListenerQueue lq = (ListenerQueue)((Handle)listeners.get(i)).getCounterListener();
            this.printQueue(lq);
            lq.assertEvent(0L, CounterState.VALID, 1L, CounterState.VALID);
            lq.assertEvent(1L, CounterState.VALID, 2L, CounterState.VALID);
            lq.assertEvent(2L, CounterState.VALID, 3L, CounterState.VALID);
            lq.assertEvent(3L, CounterState.VALID, 4L, CounterState.VALID);
            AssertJUnit.assertEquals((long)4L, (long)counters[i].getValue());
        }
    }

    public void testExceptionInListener(Method method) throws ExecutionException, InterruptedException {
        String counterName = method.getName();
        TestCounter[] counters = new TestCounter[4];
        for (int i = 0; i < 4; ++i) {
            counters[i] = this.createCounter(this.counterManager(i), counterName);
        }
        counters[0].addListener(event -> {
            throw new RuntimeException("expected 1");
        });
        Handle<ListenerQueue> l1 = counters[0].addListener(new ListenerQueue());
        counters[0].addListener(event -> {
            throw new RuntimeException("expected 2");
        });
        Handle<ListenerQueue> l2 = counters[0].addListener(new ListenerQueue());
        for (TestCounter counter : counters) {
            counter.increment();
        }
        ListenerQueue lq = (ListenerQueue)l1.getCounterListener();
        this.printQueue(lq);
        lq.assertEvent(0L, CounterState.VALID, 1L, CounterState.VALID);
        lq.assertEvent(1L, CounterState.VALID, 2L, CounterState.VALID);
        lq.assertEvent(2L, CounterState.VALID, 3L, CounterState.VALID);
        lq.assertEvent(3L, CounterState.VALID, 4L, CounterState.VALID);
        lq = (ListenerQueue)l2.getCounterListener();
        this.printQueue(lq);
        lq.assertEvent(0L, CounterState.VALID, 1L, CounterState.VALID);
        lq.assertEvent(1L, CounterState.VALID, 2L, CounterState.VALID);
        lq.assertEvent(2L, CounterState.VALID, 3L, CounterState.VALID);
        lq.assertEvent(3L, CounterState.VALID, 4L, CounterState.VALID);
        AssertJUnit.assertEquals((long)4L, (long)counters[0].getValue());
        for (TestCounter counter : counters) {
            counter.decrement();
        }
        lq = (ListenerQueue)l1.getCounterListener();
        this.printQueue(lq);
        lq.assertEvent(4L, CounterState.VALID, 3L, CounterState.VALID);
        lq.assertEvent(3L, CounterState.VALID, 2L, CounterState.VALID);
        lq.assertEvent(2L, CounterState.VALID, 1L, CounterState.VALID);
        lq.assertEvent(1L, CounterState.VALID, 0L, CounterState.VALID);
        lq = (ListenerQueue)l2.getCounterListener();
        this.printQueue(lq);
        lq.assertEvent(4L, CounterState.VALID, 3L, CounterState.VALID);
        lq.assertEvent(3L, CounterState.VALID, 2L, CounterState.VALID);
        lq.assertEvent(2L, CounterState.VALID, 1L, CounterState.VALID);
        lq.assertEvent(1L, CounterState.VALID, 0L, CounterState.VALID);
    }

    @Override
    protected int clusterSize() {
        return 4;
    }

    protected abstract TestCounter createCounter(CounterManager var1, String var2);

    protected void printQueue(ListenerQueue queue) {
        log.tracef("Queue is " + queue, new Object[0]);
    }

    protected static class ListenerQueue
    implements CounterListener {
        final BlockingQueue<CounterEvent> queue = new LinkedBlockingQueue<CounterEvent>();

        ListenerQueue() {
        }

        public void onUpdate(CounterEvent event) {
            this.queue.offer(event);
        }

        public String toString() {
            return "ListenerQueue{queue=" + this.queue + '}';
        }

        void assertEvent(long oldValue, CounterState oldState, long newValue, CounterState newState) throws InterruptedException {
            CounterEvent event = this.queue.poll(30L, TimeUnit.SECONDS);
            AssertJUnit.assertNotNull((Object)event);
            AssertJUnit.assertEquals((String)String.format("Wrong old value for event: %s.", event), (long)oldValue, (long)event.getOldValue());
            AssertJUnit.assertEquals((String)String.format("Wrong old state for event: %s.", event), (Object)oldState, (Object)event.getOldState());
            AssertJUnit.assertEquals((String)String.format("Wrong new value for event: %s.", event), (long)newValue, (long)event.getNewValue());
            AssertJUnit.assertEquals((String)String.format("Wrong new state for event: %s.", event), (Object)newState, (Object)event.getNewState());
        }
    }
}

