/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.lang.reflect.Method;
import org.infinispan.counter.AbstractCounterNotificationTest;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.util.StrongTestCounter;
import org.infinispan.counter.util.TestCounter;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="counter.BoundedCounterNotificationTest")
public class BoundedCounterNotificationTest
extends AbstractCounterNotificationTest {
    public void testThreshold(Method method) throws Exception {
        String counterName = method.getName();
        StrongCounter[] counters = new StrongCounter[this.clusterSize()];
        for (int i = 0; i < this.clusterSize(); ++i) {
            counters[i] = this.createCounter(this.counterManager(i), counterName, -2L, 2L);
        }
        Handle l = counters[0].addListener((CounterListener)new AbstractCounterNotificationTest.ListenerQueue());
        for (StrongCounter counter : counters) {
            counter.incrementAndGet();
        }
        ((AbstractCounterNotificationTest.ListenerQueue)l.getCounterListener()).assertEvent(0L, CounterState.VALID, 1L, CounterState.VALID);
        ((AbstractCounterNotificationTest.ListenerQueue)l.getCounterListener()).assertEvent(1L, CounterState.VALID, 2L, CounterState.VALID);
        ((AbstractCounterNotificationTest.ListenerQueue)l.getCounterListener()).assertEvent(2L, CounterState.VALID, 2L, CounterState.UPPER_BOUND_REACHED);
        AssertJUnit.assertTrue((boolean)((AbstractCounterNotificationTest.ListenerQueue)l.getCounterListener()).queue.isEmpty());
        AssertJUnit.assertEquals((long)2L, (long)((Long)counters[0].getValue().get()));
        for (StrongCounter counter : counters) {
            counter.decrementAndGet();
        }
        ((AbstractCounterNotificationTest.ListenerQueue)l.getCounterListener()).assertEvent(2L, CounterState.UPPER_BOUND_REACHED, 1L, CounterState.VALID);
        ((AbstractCounterNotificationTest.ListenerQueue)l.getCounterListener()).assertEvent(1L, CounterState.VALID, 0L, CounterState.VALID);
        ((AbstractCounterNotificationTest.ListenerQueue)l.getCounterListener()).assertEvent(0L, CounterState.VALID, -1L, CounterState.VALID);
        ((AbstractCounterNotificationTest.ListenerQueue)l.getCounterListener()).assertEvent(-1L, CounterState.VALID, -2L, CounterState.VALID);
        AssertJUnit.assertEquals((long)-2L, (long)((Long)counters[0].getValue().get()));
        counters[0].decrementAndGet();
        counters[0].decrementAndGet();
        ((AbstractCounterNotificationTest.ListenerQueue)l.getCounterListener()).assertEvent(-2L, CounterState.VALID, -2L, CounterState.LOWER_BOUND_REACHED);
        AssertJUnit.assertTrue((boolean)((AbstractCounterNotificationTest.ListenerQueue)l.getCounterListener()).queue.isEmpty());
        AssertJUnit.assertEquals((long)-2L, (long)((Long)counters[0].getValue().get()));
        l.remove();
        counters[0].incrementAndGet();
        counters[0].incrementAndGet();
        AssertJUnit.assertTrue((boolean)((AbstractCounterNotificationTest.ListenerQueue)l.getCounterListener()).queue.isEmpty());
    }

    @Override
    protected TestCounter createCounter(CounterManager counterManager, String counterName) {
        return new StrongTestCounter(this.createCounter(counterManager, counterName, Long.MIN_VALUE, Long.MAX_VALUE));
    }

    private StrongCounter createCounter(CounterManager counterManager, String counterName, long min, long max) {
        counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).lowerBound(min).upperBound(max).build());
        return counterManager.getStrongCounter(counterName);
    }
}

