/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.strong;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.infinispan.AdvancedCache;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.function.AddFunction;
import org.infinispan.counter.impl.function.CompareAndSetFunction;
import org.infinispan.counter.impl.function.InitializeCounterFunction;
import org.infinispan.counter.impl.function.ReadFunction;
import org.infinispan.counter.impl.function.ResetFunction;
import org.infinispan.counter.impl.listener.CounterEventImpl;
import org.infinispan.counter.impl.listener.CounterFilterAndConvert;
import org.infinispan.counter.impl.listener.NotificationManager;
import org.infinispan.counter.impl.strong.StrongCounterKey;
import org.infinispan.counter.logging.Log;
import org.infinispan.counter.util.Utils;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadOnlyMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;

@Listener(clustered=true, observation=Listener.Observation.POST, sync=true)
public abstract class AbstractStrongCounter
implements StrongCounter {
    final StrongCounterKey key;
    private final FunctionalMap.ReadWriteMap<StrongCounterKey, CounterValue> readWriteMap;
    private final FunctionalMap.ReadOnlyMap<StrongCounterKey, CounterValue> readOnlyMap;
    private final NotificationManager notificationManager;
    private final CounterConfiguration configuration;
    private CounterValue weakCounter;

    AbstractStrongCounter(String counterName, AdvancedCache<StrongCounterKey, CounterValue> cache, CounterConfiguration configuration) {
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create(cache).withParams(new Param[]{Utils.getPersistenceMode(configuration.storage())});
        this.key = new StrongCounterKey(counterName);
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
        this.readOnlyMap = ReadOnlyMapImpl.create((FunctionalMapImpl)functionalMap);
        this.notificationManager = new NotificationManager();
        this.weakCounter = null;
        this.configuration = configuration;
        this.registerListener(cache);
    }

    public final void init() {
        try {
            CounterValue existingValue = (CounterValue)this.readWriteMap.eval((Object)this.key, new InitializeCounterFunction(this.configuration)).get();
            this.initCounterState(existingValue == null ? CounterValue.newCounterValue(this.configuration) : existingValue);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CounterException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Utils.rethrowAsCounterException(e);
        }
    }

    public final String getName() {
        return this.key.getCounterName().toString();
    }

    public final CompletableFuture<Long> getValue() {
        return this.readOnlyMap.eval((Object)this.key, ReadFunction.getInstance()).thenApply(this::handleReadResult);
    }

    public final CompletableFuture<Long> addAndGet(long delta) {
        return this.readWriteMap.eval((Object)this.key, new AddFunction(delta)).thenApply(this::handleAddResult);
    }

    public final CompletableFuture<Void> reset() {
        return this.readWriteMap.eval((Object)this.key, ResetFunction.getInstance());
    }

    public final <T extends CounterListener> Handle<T> addListener(T listener) {
        return this.notificationManager.addListener(listener);
    }

    public CompletableFuture<Boolean> compareAndSet(long expect, long update) {
        return this.readWriteMap.eval((Object)this.key, new CompareAndSetFunction(expect, update)).thenApply(this::handleCASResult);
    }

    @CacheEntryModified
    public synchronized void updateState(CacheEntryEvent<StrongCounterKey, CounterValue> event) {
        CounterValue snapshot = (CounterValue)event.getValue();
        this.notificationManager.notify(CounterEventImpl.create(this.weakCounter, snapshot));
        this.weakCounter = snapshot;
    }

    public final CounterConfiguration getConfiguration() {
        return this.configuration;
    }

    protected abstract Boolean handleCASResult(CounterState var1);

    protected abstract long handleAddResult(CounterValue var1);

    protected abstract Log getLog();

    private void registerListener(AdvancedCache<StrongCounterKey, CounterValue> cache) {
        CounterFilterAndConvert filter = new CounterFilterAndConvert(this.key.getCounterName());
        cache.addListener((Object)this, filter, filter);
    }

    private synchronized void initCounterState(CounterValue value) {
        if (this.weakCounter == null) {
            this.weakCounter = value;
        }
    }

    private long handleReadResult(Long value) {
        if (value != null) {
            return value;
        }
        throw new CompletionException((Throwable)this.getLog().counterDeleted());
    }
}

