/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.Attribute;
import org.infinispan.counter.configuration.CounterManagerConfiguration;
import org.infinispan.counter.configuration.Element;
import org.infinispan.counter.configuration.StrongCounterConfiguration;
import org.infinispan.counter.configuration.WeakCounterConfiguration;

public class CounterConfigurationSerializer
implements ConfigurationSerializer<CounterManagerConfiguration> {
    public void serialize(XMLExtendedStreamWriter writer, CounterManagerConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement((Enum)Element.COUNTERS);
        configuration.attributes().write((XMLStreamWriter)writer);
        for (AbstractCounterConfiguration c : configuration.counters()) {
            if (c instanceof StrongCounterConfiguration) {
                this.writeStrongConfiguration((StrongCounterConfiguration)c, writer);
                continue;
            }
            if (!(c instanceof WeakCounterConfiguration)) continue;
            this.writeWeakConfiguration((WeakCounterConfiguration)c, writer);
        }
        writer.writeEndElement();
    }

    private void writeWeakConfiguration(WeakCounterConfiguration configuration, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement((Enum)Element.WEAK_COUNTER);
        configuration.attributes().write((XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeStrongConfiguration(StrongCounterConfiguration configuration, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement((Enum)Element.STRONG_COUNTER);
        configuration.attributes().write((XMLStreamWriter)writer);
        if (configuration.attributes().attribute(StrongCounterConfiguration.LOWER_BOUND).isModified()) {
            this.writeBound(Element.LOWER_BOUND, configuration.lowerBound(), writer);
        }
        if (configuration.attributes().attribute(StrongCounterConfiguration.UPPER_BOUND).isModified()) {
            this.writeBound(Element.UPPER_BOUND, configuration.upperBound(), writer);
        }
        writer.writeEndElement();
    }

    private void writeBound(Element element, long value, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement((Enum)element);
        writer.writeAttribute((Enum)Attribute.VALUE, Long.toString(value));
        writer.writeEndElement();
    }
}

