/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.manager;

import java.util.List;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.StrongCounterConfiguration;
import org.infinispan.counter.configuration.WeakCounterConfiguration;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.listener.CounterManagerNotificationManager;

public class CacheHolder {
    private final AdvancedCache<String, CounterConfiguration> configurationCache;
    private final AdvancedCache<? extends CounterKey, CounterValue> counterCache;
    private final List<AbstractCounterConfiguration> defaultCounters;

    public CacheHolder(AdvancedCache<String, CounterConfiguration> configurationCache, AdvancedCache<? extends CounterKey, CounterValue> counterCache, List<AbstractCounterConfiguration> defaultCounters) {
        this.configurationCache = configurationCache;
        this.counterCache = counterCache;
        this.defaultCounters = defaultCounters;
    }

    void registerNotificationManager(CounterManagerNotificationManager notificationManager) {
        notificationManager.listenOn((Cache<? extends CounterKey, CounterValue>)this.counterCache);
    }

    boolean addConfiguration(String name, CounterConfiguration configuration) {
        CounterConfiguration existing = this.checkAndStoreConfiguredCounterConfiguration(name);
        if (existing != null) {
            return false;
        }
        AdvancedCache cache = configuration.storage() == Storage.VOLATILE ? this.configurationCache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD}) : this.configurationCache;
        return cache.putIfAbsent((Object)name, (Object)configuration) == null;
    }

    <K extends CounterKey> AdvancedCache<K, CounterValue> getCounterCache(CounterConfiguration configuration) {
        return configuration.storage() == Storage.VOLATILE ? this.counterCache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE}) : this.counterCache;
    }

    CounterConfiguration getConfiguration(String counterName) {
        CounterConfiguration config = (CounterConfiguration)this.configurationCache.get((Object)counterName);
        return config == null ? this.checkAndStoreConfiguredCounterConfiguration(counterName) : config;
    }

    private CounterConfiguration checkAndStoreConfiguredCounterConfiguration(String counterName) {
        for (AbstractCounterConfiguration config : this.defaultCounters) {
            if (!config.name().equals(counterName)) continue;
            CounterConfiguration counterConfiguration = CacheHolder.createConfigurationEntry(config);
            CounterConfiguration existing = (CounterConfiguration)this.configurationCache.putIfAbsent((Object)counterName, (Object)counterConfiguration);
            return existing == null ? counterConfiguration : existing;
        }
        return null;
    }

    private static CounterConfiguration createConfigurationEntry(AbstractCounterConfiguration configuration) {
        if (configuration instanceof StrongCounterConfiguration) {
            if (((StrongCounterConfiguration)configuration).isBound()) {
                return CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(configuration.initialValue()).lowerBound(((StrongCounterConfiguration)configuration).lowerBound()).upperBound(((StrongCounterConfiguration)configuration).upperBound()).storage(configuration.storage()).build();
            }
            return CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue(configuration.initialValue()).storage(configuration.storage()).build();
        }
        if (configuration instanceof WeakCounterConfiguration) {
            return CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(configuration.initialValue()).storage(configuration.storage()).concurrencyLevel(((WeakCounterConfiguration)configuration).concurrencyLevel()).build();
        }
        throw new IllegalStateException("[should never happen] unknown CounterConfiguration class: " + configuration.getClass());
    }
}

