/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.manager;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.impl.listener.CounterManagerNotificationManager;
import org.infinispan.counter.impl.manager.CacheHolder;
import org.infinispan.counter.impl.strong.AbstractStrongCounter;
import org.infinispan.counter.impl.strong.BoundedStrongCounter;
import org.infinispan.counter.impl.strong.UnboundedStrongCounter;
import org.infinispan.counter.impl.weak.WeakCounterImpl;
import org.infinispan.counter.logging.Log;
import org.infinispan.counter.util.Utils;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;

public class EmbeddedCounterManager
implements CounterManager {
    private static final long WAIT_CACHES_TIMEOUT = TimeUnit.SECONDS.toNanos(15L);
    private static final Log log = (Log)LogFactory.getLog(EmbeddedCounterManager.class, Log.class);
    private final Map<String, Object> counters;
    private final CompletableFuture<CacheHolder> future;
    private final boolean allowPersistence;
    private final CounterManagerNotificationManager notificationManager;

    public EmbeddedCounterManager(CompletableFuture<CacheHolder> future, boolean allowPersistence) {
        this.allowPersistence = allowPersistence;
        this.counters = new ConcurrentHashMap<String, Object>();
        this.future = future;
        this.notificationManager = new CounterManagerNotificationManager();
    }

    @Inject
    public void injectExecutor(@ComponentName(value="org.infinispan.executors.async") Executor executor) {
        this.notificationManager.useExecutor(executor);
    }

    private static <T> T validateCounter(Class<T> tClass, Object retVal) {
        Class<?> rClass = retVal.getClass();
        if (tClass.isAssignableFrom(rClass)) {
            return tClass.cast(retVal);
        }
        throw log.invalidCounterType(tClass.getSimpleName(), rClass.getSimpleName());
    }

    private static CacheHolder extractCacheHolder(CompletableFuture<CacheHolder> future) {
        try {
            return future.get(WAIT_CACHES_TIMEOUT, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.interruptedWhileWaitingForCaches();
            return null;
        }
        catch (ExecutionException | TimeoutException e) {
            log.exceptionWhileWaitingForCached(e);
            return null;
        }
    }

    private static WeakCounter createWeakCounter(String counterName, CounterConfiguration configuration, CacheHolder holder, CounterManagerNotificationManager notificationManager) {
        WeakCounterImpl counter = new WeakCounterImpl(counterName, holder.getCounterCache(configuration), configuration, notificationManager);
        counter.init();
        return counter;
    }

    private static StrongCounter createBoundedStrongCounter(String counterName, CounterConfiguration configuration, CacheHolder holder, CounterManagerNotificationManager notificationManager) {
        BoundedStrongCounter counter = new BoundedStrongCounter(counterName, holder.getCounterCache(configuration), configuration, notificationManager);
        counter.init();
        return counter;
    }

    private static StrongCounter createUnboundedStrongCounter(String counterName, CounterConfiguration configuration, CacheHolder holder, CounterManagerNotificationManager notificationManager) {
        UnboundedStrongCounter counter = new UnboundedStrongCounter(counterName, holder.getCounterCache(configuration), configuration, notificationManager);
        counter.init();
        return counter;
    }

    public StrongCounter getStrongCounter(String name) {
        Object counter = this.counters.computeIfAbsent(name, this::createCounter);
        return EmbeddedCounterManager.validateCounter(StrongCounter.class, counter);
    }

    public WeakCounter getWeakCounter(String name) {
        Object counter = this.counters.computeIfAbsent(name, this::createCounter);
        return EmbeddedCounterManager.validateCounter(WeakCounter.class, counter);
    }

    public boolean defineCounter(String name, CounterConfiguration configuration) {
        this.validateConfiguration(configuration);
        CacheHolder holder = EmbeddedCounterManager.extractCacheHolder(this.future);
        return holder != null && holder.addConfiguration(name, configuration);
    }

    public boolean isDefined(String name) {
        CacheHolder holder = EmbeddedCounterManager.extractCacheHolder(this.future);
        return holder != null && holder.getConfiguration(name) != null;
    }

    public CounterConfiguration getConfiguration(String counterName) {
        CacheHolder holder = EmbeddedCounterManager.extractCacheHolder(this.future);
        return holder == null ? null : holder.getConfiguration(counterName);
    }

    public void remove(String counterName) {
        CacheHolder holder = EmbeddedCounterManager.extractCacheHolder(this.future);
        if (holder == null) {
            throw log.unableToFetchCaches();
        }
        CounterConfiguration configuration = holder.getConfiguration(counterName);
        if (configuration == null) {
            return;
        }
        this.counters.compute(counterName, (name, counter) -> {
            this.removeCounter((String)name, counter, configuration, holder);
            return null;
        });
    }

    private void removeCounter(String name, Object counter, CounterConfiguration configuration, CacheHolder holder) {
        if (configuration.type() == CounterType.WEAK) {
            if (counter == null) {
                WeakCounterImpl.removeWeakCounter(holder.getCounterCache(configuration), configuration, name);
            } else {
                ((WeakCounterImpl)counter).destroyAndRemove();
            }
        } else if (counter == null) {
            AbstractStrongCounter.removeStrongCounter(holder.getCounterCache(configuration), name);
        } else {
            ((AbstractStrongCounter)counter).destroyAndRemove();
        }
    }

    private Object createCounter(String counterName) {
        CacheHolder holder = EmbeddedCounterManager.extractCacheHolder(this.future);
        if (holder == null) {
            throw log.unableToFetchCaches();
        }
        CounterConfiguration configuration = holder.getConfiguration(counterName);
        if (configuration == null) {
            throw log.undefinedCounter(counterName);
        }
        holder.registerNotificationManager(this.notificationManager);
        switch (configuration.type()) {
            case WEAK: {
                return EmbeddedCounterManager.createWeakCounter(counterName, configuration, holder, this.notificationManager);
            }
            case BOUNDED_STRONG: {
                return EmbeddedCounterManager.createBoundedStrongCounter(counterName, configuration, holder, this.notificationManager);
            }
            case UNBOUNDED_STRONG: {
                return EmbeddedCounterManager.createUnboundedStrongCounter(counterName, configuration, holder, this.notificationManager);
            }
        }
        throw new IllegalStateException("[should never happen] unknown counter type: " + configuration.type());
    }

    private void validateConfiguration(CounterConfiguration configuration) {
        if (!this.allowPersistence && configuration.storage() == Storage.PERSISTENT) {
            throw log.invalidPersistentStorageMode();
        }
        switch (configuration.type()) {
            case BOUNDED_STRONG: {
                if (!Utils.isValid(configuration.lowerBound(), configuration.initialValue(), configuration.upperBound())) break;
                throw log.invalidInitialValueForBoundedCounter(configuration.lowerBound(), configuration.upperBound(), configuration.initialValue());
            }
            case WEAK: {
                if (configuration.concurrencyLevel() >= 1) break;
                throw log.invalidConcurrencyLevel(configuration.concurrencyLevel());
            }
        }
    }
}

