/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.CounterManagerConfiguration;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.counter.configuration.Reliability;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.function.AddFunction;
import org.infinispan.counter.impl.function.CompareAndSwapFunction;
import org.infinispan.counter.impl.function.CreateAndAddFunction;
import org.infinispan.counter.impl.function.CreateAndCASFunction;
import org.infinispan.counter.impl.function.InitializeCounterFunction;
import org.infinispan.counter.impl.function.ReadFunction;
import org.infinispan.counter.impl.function.RemoveFunction;
import org.infinispan.counter.impl.function.ResetFunction;
import org.infinispan.counter.impl.interceptor.CounterConfigurationInterceptor;
import org.infinispan.counter.impl.interceptor.CounterInterceptor;
import org.infinispan.counter.impl.listener.CounterKeyFilter;
import org.infinispan.counter.impl.manager.CacheHolder;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.counter.impl.metadata.ConfigurationMetadata;
import org.infinispan.counter.impl.strong.StrongCounterKey;
import org.infinispan.counter.impl.weak.WeakCounterKey;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.transaction.TransactionMode;

public class CounterModuleLifecycle
implements ModuleLifecycle {
    public static final String COUNTER_CACHE_NAME = "___counters";
    public static final String COUNTER_CONFIGURATION_CACHE_NAME = "___counter_configuration";

    private static Configuration createCounterCacheConfiguration(CounterManagerConfiguration config) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(config.numOwners()).stateTransfer().fetchInMemoryState(true).l1().disable().partitionHandling().whenSplit(config.reliability() == Reliability.CONSISTENT ? PartitionHandling.DENY_READ_WRITES : PartitionHandling.ALLOW_READ_WRITES).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).customInterceptors().addInterceptor().after(EntryWrappingInterceptor.class).interceptor((AsyncInterceptor)new CounterInterceptor());
        return builder.build();
    }

    private static Configuration createCounterConfigurationCacheConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).l1().disable().stateTransfer().fetchInMemoryState(true).partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).customInterceptors().addInterceptor().after(EntryWrappingInterceptor.class).interceptor((AsyncInterceptor)new CounterConfigurationInterceptor());
        return builder.build();
    }

    private static void addAdvancedExternalizer(Map<Integer, AdvancedExternalizer<?>> map, AdvancedExternalizer<?> ext) {
        map.put(ext.getId(), ext);
    }

    private static CounterManagerConfiguration extractConfiguration(GlobalComponentRegistry globalComponentRegistry) {
        CounterManagerConfiguration config = (CounterManagerConfiguration)globalComponentRegistry.getGlobalConfiguration().module(CounterManagerConfiguration.class);
        return config == null ? CounterManagerConfigurationBuilder.defaultConfiguration() : config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerCounterManager(GlobalComponentRegistry registry, CompletableFuture<CacheHolder> future) {
        GlobalComponentRegistry globalComponentRegistry = registry;
        synchronized (globalComponentRegistry) {
            CounterManager counterManager = (CounterManager)registry.getComponent(CounterManager.class);
            if (counterManager == null || !(counterManager instanceof EmbeddedCounterManager)) {
                counterManager = new EmbeddedCounterManager(future, registry.getGlobalConfiguration().globalState().enabled());
                registry.registerComponent((Object)counterManager, CounterManager.class);
                ((CacheManagerJmxRegistration)registry.getComponent(CacheManagerJmxRegistration.class)).start();
            }
        }
    }

    private static void registerCounterCache(InternalCacheRegistry registry, CounterManagerConfiguration config) {
        registry.registerInternalCache(COUNTER_CACHE_NAME, CounterModuleLifecycle.createCounterCacheConfiguration(config), EnumSet.of(InternalCacheRegistry.Flag.EXCLUSIVE, InternalCacheRegistry.Flag.PERSISTENT));
    }

    private static void registerConfigurationCache(InternalCacheRegistry registry) {
        registry.registerInternalCache(COUNTER_CONFIGURATION_CACHE_NAME, CounterModuleLifecycle.createCounterConfigurationCacheConfiguration(), EnumSet.of(InternalCacheRegistry.Flag.EXCLUSIVE, InternalCacheRegistry.Flag.PERSISTENT));
    }

    private static CompletableFuture<CacheHolder> startCaches(EmbeddedCacheManager cacheManager, List<AbstractCounterConfiguration> defaultCounters) {
        CompletableFuture<CacheHolder> future = new CompletableFuture<CacheHolder>();
        new Thread(() -> {
            try {
                Cache configCache = cacheManager.getCache(COUNTER_CONFIGURATION_CACHE_NAME);
                Cache counterCache = cacheManager.getCache(COUNTER_CACHE_NAME);
                future.complete(new CacheHolder((AdvancedCache<String, CounterConfiguration>)configCache.getAdvancedCache(), (AdvancedCache<? extends CounterKey, CounterValue>)counterCache.getAdvancedCache(), defaultCounters));
            }
            catch (Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }).start();
        return future;
    }

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        Map externalizerMap = globalConfiguration.serialization().advancedExternalizers();
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, ResetFunction.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, CounterKeyFilter.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, StrongCounterKey.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, WeakCounterKey.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, ReadFunction.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, CounterConfiguration.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, CounterValue.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, InitializeCounterFunction.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, ConfigurationMetadata.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, AddFunction.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, CompareAndSwapFunction.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, CounterState.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, CreateAndCASFunction.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, CreateAndAddFunction.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, RemoveFunction.EXTERNALIZER);
    }

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class);
        InternalCacheRegistry internalCacheRegistry = (InternalCacheRegistry)gcr.getComponent(InternalCacheRegistry.class);
        CounterManagerConfiguration counterManagerConfiguration = CounterModuleLifecycle.extractConfiguration(gcr);
        CounterModuleLifecycle.registerCounterCache(internalCacheRegistry, counterManagerConfiguration);
        CounterModuleLifecycle.registerConfigurationCache(internalCacheRegistry);
        CompletableFuture<CacheHolder> future = CounterModuleLifecycle.startCaches(cacheManager, counterManagerConfiguration.counters());
        CounterModuleLifecycle.registerCounterManager(gcr, future);
    }
}

