/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.lang.reflect.Method;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.impl.BaseCounterTest;
import org.infinispan.counter.util.StrongTestCounter;
import org.infinispan.counter.util.TestCounter;
import org.infinispan.counter.util.WeakTestCounter;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="counter.RemoveCounterTest")
public class RemoveCounterTest
extends BaseCounterTest {
    public void testCounterManagerRemoveWithUnbounded(Method method) {
        this.testCounterManagerRemove(Factory.UNBOUNDED, method.getName());
    }

    public void testCounterManagerRemoveWithBounded(Method method) {
        this.testCounterManagerRemove(Factory.BOUNDED, method.getName());
    }

    public void testCounterManagerRemoveWithWeak(Method method) {
        this.testCounterManagerRemove(Factory.WEAK, method.getName());
    }

    public void testCounterManagerRemoveNonExistingWithUnbounded(Method method) {
        this.testCounterManagerRemoveNonExisting(Factory.UNBOUNDED, method.getName());
    }

    public void testCounterManagerNonExistingRemoveWithBounded(Method method) {
        this.testCounterManagerRemoveNonExisting(Factory.BOUNDED, method.getName());
    }

    public void testCounterManagerNonExistingRemoveWithWeak(Method method) {
        this.testCounterManagerRemoveNonExisting(Factory.WEAK, method.getName());
    }

    public void testCounterRemoveWithUnbounded(Method method) {
        this.testCounterRemove(Factory.UNBOUNDED, method.getName());
    }

    public void testCounterRemoveWithBounded(Method method) {
        this.testCounterRemove(Factory.BOUNDED, method.getName());
    }

    public void testCounterRemoveWithWeak(Method method) {
        this.testCounterRemove(Factory.BOUNDED, method.getName());
    }

    @Override
    protected int clusterSize() {
        return 3;
    }

    private void testCounterRemove(Factory factory, String counterName) {
        CounterManager manager = this.counterManager(0);
        factory.define(manager, counterName);
        TestCounter counter = factory.get(manager, counterName);
        AssertJUnit.assertEquals((long)10L, (long)counter.getValue());
        AssertJUnit.assertTrue((boolean)counter.isSame(factory.get(manager, counterName)));
        this.assertCounterRemove(counterName, counter, factory);
        counter.increment();
        AssertJUnit.assertEquals((long)11L, (long)counter.getValue());
        this.assertCounterRemove(counterName, counter, factory);
        counter.decrement();
        AssertJUnit.assertEquals((long)9L, (long)counter.getValue());
        this.assertCounterRemove(counterName, counter, factory);
        counter.reset();
        AssertJUnit.assertEquals((long)10L, (long)counter.getValue());
    }

    private void testCounterManagerRemove(Factory factory, String counterName) {
        CounterManager manager = this.counterManager(0);
        factory.define(manager, counterName);
        TestCounter counter = factory.get(manager, counterName);
        AssertJUnit.assertEquals((long)10L, (long)counter.getValue());
        AssertJUnit.assertTrue((boolean)counter.isSame(factory.get(manager, counterName)));
        counter = this.assertCounterManagerRemove(counterName, counter, factory, 0);
        counter.increment();
        AssertJUnit.assertEquals((long)11L, (long)counter.getValue());
        counter = this.assertCounterManagerRemove(counterName, counter, factory, 0);
        counter.decrement();
        AssertJUnit.assertEquals((long)9L, (long)counter.getValue());
        counter = this.assertCounterManagerRemove(counterName, counter, factory, 0);
        counter.reset();
        AssertJUnit.assertEquals((long)10L, (long)counter.getValue());
    }

    private TestCounter assertCounterManagerRemove(String name, TestCounter counter, Factory factory, int index) {
        CounterManager manager = this.counterManager(index);
        manager.remove(name);
        AssertJUnit.assertTrue((boolean)this.cache(0, "___counters").isEmpty());
        TestCounter anotherCounter = factory.get(manager, name);
        if (counter != null) {
            AssertJUnit.assertFalse((boolean)counter.isSame(anotherCounter));
        }
        return anotherCounter;
    }

    private void assertCounterRemove(String name, TestCounter counter, Factory factory) {
        CounterManager manager = this.counterManager(0);
        counter.remove();
        AssertJUnit.assertTrue((boolean)this.cache(0, "___counters").isEmpty());
        TestCounter anotherCounter = factory.get(manager, name);
        AssertJUnit.assertTrue((boolean)counter.isSame(anotherCounter));
    }

    private void testCounterManagerRemoveNonExisting(Factory factory, String counterName) {
        CounterManager manager = this.counterManager(0);
        factory.define(manager, counterName);
        TestCounter counter = factory.get(manager, counterName);
        AssertJUnit.assertEquals((long)10L, (long)counter.getValue());
        AssertJUnit.assertTrue((boolean)counter.isSame(factory.get(manager, counterName)));
        counter = this.assertCounterManagerRemove(counterName, counter, factory, 1);
        counter.increment();
        AssertJUnit.assertEquals((long)11L, (long)counter.getValue());
        counter = this.assertCounterManagerRemove(counterName, counter, factory, 1);
        counter.decrement();
        AssertJUnit.assertEquals((long)9L, (long)counter.getValue());
        counter = this.assertCounterManagerRemove(counterName, counter, factory, 1);
        counter.reset();
        AssertJUnit.assertEquals((long)10L, (long)counter.getValue());
    }

    private static enum Factory {
        UNBOUNDED{

            @Override
            void define(CounterManager manager, String name) {
                manager.defineCounter(name, CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue(10L).build());
            }

            @Override
            TestCounter get(CounterManager manager, String name) {
                return new StrongTestCounter(manager.getStrongCounter(name));
            }
        }
        ,
        BOUNDED{

            @Override
            void define(CounterManager manager, String name) {
                manager.defineCounter(name, CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(10L).lowerBound(0L).upperBound(20L).build());
            }

            @Override
            TestCounter get(CounterManager manager, String name) {
                return new StrongTestCounter(manager.getStrongCounter(name));
            }
        }
        ,
        WEAK{

            @Override
            void define(CounterManager manager, String name) {
                manager.defineCounter(name, CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(10L).build());
            }

            @Override
            TestCounter get(CounterManager manager, String name) {
                return new WeakTestCounter(manager.getWeakCounter(name));
            }
        };


        abstract void define(CounterManager var1, String var2);

        abstract TestCounter get(CounterManager var1, String var2);
    }
}

