/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.logging;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.counter.exception.CounterConfigurationException;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.counter.exception.CounterOutOfBoundsException;
import org.infinispan.counter.logging.Log;
import org.infinispan.util.ByteString;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Serializable,
org.infinispan.commons.logging.Log,
Log,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final String missingCounterName = "ISPN028003: The counter name is missing.";
    private static final String invalidStorageMode = "ISPN028004: Invalid storage mode. It must be non-null";
    private static final String invalidPersistentStorageMode = "ISPN028005: Invalid storage mode. PERSISTENT is not allowed without global state enabled in cache container.";
    private static final String invalidNumOwners = "ISPN028006: Invalid number of owner. It must be higher than zero but it was %s";
    private static final String invalidReliabilityMode = "ISPN028007: Invalid reliability mode. It must be non-null";
    private static final String invalidInitialValueForBoundedCounter = "ISPN028008: Invalid initial value for counter. It must be between %s and %s (inclusive) but was %s";
    private static final String invalidConcurrencyLevel = "ISPN028009: Invalid concurrency-level. It must be higher than zero but it was %s";
    private static final String interruptedWhileWaitingForCaches = "ISPN028012: Interrupted while waiting for the counter manager caches.";
    private static final String exceptionWhileWaitingForCached = "ISPN028013: Exception while waiting for counter manager caches.";
    private static final String unableToFetchCaches = "ISPN028015: Unable to fetch counter manager caches.";
    private static final String duplicatedCounterName = "ISPN028017: Duplicated counter name found. Counter '%s' already exists.";
    private static final String metadataIsMissing = "ISPN028018: Metadata not found but counter exists. Counter=%s";
    private static final String invalidScope = "ISPN028020: Invalid scope for tag <counter>. Expected CACHE_CONTAINER but was %s";
    private static final String expectedClusteredEnvironment = "ISPN028021: Clustered counters only available with clustered cache manager.";
    private static final String propertyCouldNotBeReplaced = "ISPN000901: Property %s could not be replaced as intended!";
    private static final String ignoringException = "ISPN000902: Invocation of %s threw an exception %s. Exception is ignored.";
    private static final String unableToSetValue = "ISPN000903: Unable to set value!";
    private static final String sslInitializationException = "ISPN000904: Error while initializing SSL context";
    private static final String unableToLoadClass = "ISPN000905: Unable to load %s from any of the following classloaders: %s";
    private static final String unableToConvertStringPropertyToInt = "ISPN000906: Unable to convert string property [%s] to an int! Using default value of %d";
    private static final String unableToConvertStringPropertyToLong = "ISPN000907: Unable to convert string property [%s] to a long! Using default value of %d";
    private static final String unableToConvertStringPropertyToBoolean = "ISPN000908: Unable to convert string property [%s] to a boolean! Using default value of %b";
    private static final String unableToUnwrap = "ISPN000909: Unwrapping %s to a type of %s is not a supported";
    private static final String illegalValueThreadPoolParameter = "ISPN000910: Illegal value for thread pool parameter(s) %s, it should be: %s";
    private static final String unableToUnwrapAny = "ISPN000911: Unwrapping of any instances in %s to a type of %s is not a supported";
    private static final String unprotectedAttributeSet = "ISPN000912: Expecting a protected configuration for %s";
    private static final String protectedAttributeSet = "ISPN000913: Expecting a unprotected configuration for %s";
    private static final String attributeSetDuplicateAttribute = "ISPN000914: Duplicate attribute '%s' in attribute set '%s'";
    private static final String noSuchAttribute = "ISPN000915: No such attribute '%s' in attribute set '%s'";
    private static final String noAttributeCopierForType = "ISPN000916: No attribute copier for type '%s'";
    private static final String cannotResizeUnboundedContainer = "ISPN000917: Cannot resize unbounded container";
    private static final String cannotFindResource = "ISPN000918: Cannot find resource '%s'";
    private static final String multipleConfigurationValidationErrors = "ISPN000919: Multiple errors encountered while validating configuration";
    private static final String unableToLoadFileUsingScheme = "ISPN000920: Unable to load file using scheme %s";
    private static final String noSuchAliasInKeyStore = "ISPN000921: The alias '%s' does not exist in the key store '%s'";
    private static final String errorRollingBack = "ISPN000922: Exception during rollback";
    private static final String errorEnlistingResource = "ISPN000923: Error enlisting resource";
    private static final String beforeCompletionFailed = "ISPN000924: beforeCompletion() failed for %s";
    private static final String unexpectedErrorFromResourceManager = "ISPN000925: Unexpected error from resource manager!";
    private static final String afterCompletionFailed = "ISPN000926: afterCompletion() failed for %s";
    private static final String errorCommittingTx = "ISPN000927: exception while committing";
    private static final String xaResourceEndFailed = "ISPN000928: end() failed for %s";
    private static final String missingMediaType = "ISPN000929: MediaType cannot be empty or null!";
    private static final String invalidMediaTypeSubtype = "ISPN000930: MediaType must contain a type and a subtype separated by '/'";
    private static final String invalidMediaTypeParam = "ISPN000931: Failed to parse MediaType: Invalid param description '%s'";
    private static final String unquotedMediaTypeParam = "ISPN000932: Unclosed param value quote";
    private static final String invalidCharMediaType = "ISPN000933: Invalid character '%s' found in token '%s'";
    private static final String unsupportedContent = "ISPN000934: Unsupported content '%s'";
    private static final String counterOurOfBounds = "ISPN028001: %s reached.";
    private static final String invalidCounterType = "ISPN028014: Invalid counter type. Expected=%s but got %s";
    private static final String undefinedCounter = "ISPN028016: Counter '%s' is not defined.";
    private static final String invalidCounterTypeEncoded = "ISPN028022: WEAK and BOUNDED encoded flag isn't supported!";

    public Log_$logger(Logger log) {
        super(log);
    }

    @Override
    public final CounterConfigurationException missingCounterName() {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.missingCounterName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingCounterName$str() {
        return missingCounterName;
    }

    @Override
    public final CounterConfigurationException invalidStorageMode() {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidStorageMode$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidStorageMode$str() {
        return invalidStorageMode;
    }

    @Override
    public final CounterConfigurationException invalidPersistentStorageMode() {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidPersistentStorageMode$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPersistentStorageMode$str() {
        return invalidPersistentStorageMode;
    }

    @Override
    public final CounterConfigurationException invalidNumOwners(int value) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidNumOwners$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNumOwners$str() {
        return invalidNumOwners;
    }

    @Override
    public final CounterConfigurationException invalidReliabilityMode() {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidReliabilityMode$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidReliabilityMode$str() {
        return invalidReliabilityMode;
    }

    @Override
    public final CounterConfigurationException invalidInitialValueForBoundedCounter(long lower, long upper, long value) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidInitialValueForBoundedCounter$str(), lower, upper, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidInitialValueForBoundedCounter$str() {
        return invalidInitialValueForBoundedCounter;
    }

    @Override
    public final CounterConfigurationException invalidConcurrencyLevel(int value) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidConcurrencyLevel$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConcurrencyLevel$str() {
        return invalidConcurrencyLevel;
    }

    @Override
    public final void interruptedWhileWaitingForCaches() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.interruptedWhileWaitingForCaches$str(), new Object[0]);
    }

    protected String interruptedWhileWaitingForCaches$str() {
        return interruptedWhileWaitingForCaches;
    }

    @Override
    public final void exceptionWhileWaitingForCached(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.exceptionWhileWaitingForCached$str(), new Object[0]);
    }

    protected String exceptionWhileWaitingForCached$str() {
        return exceptionWhileWaitingForCached;
    }

    @Override
    public final CounterException unableToFetchCaches() {
        CounterException result = new CounterException(String.format(this.unableToFetchCaches$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToFetchCaches$str() {
        return unableToFetchCaches;
    }

    @Override
    public final CounterConfigurationException duplicatedCounterName(String counter) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.duplicatedCounterName$str(), counter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicatedCounterName$str() {
        return duplicatedCounterName;
    }

    @Override
    public final IllegalStateException metadataIsMissing(ByteString counterName) {
        IllegalStateException result = new IllegalStateException(String.format(this.metadataIsMissing$str(), counterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String metadataIsMissing$str() {
        return metadataIsMissing;
    }

    @Override
    public final CounterConfigurationException invalidScope(ParserScope scope) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidScope$str(), scope));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidScope$str() {
        return invalidScope;
    }

    @Override
    public final CounterException expectedClusteredEnvironment() {
        CounterException result = new CounterException(String.format(this.expectedClusteredEnvironment$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String expectedClusteredEnvironment$str() {
        return expectedClusteredEnvironment;
    }

    public final void propertyCouldNotBeReplaced(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.propertyCouldNotBeReplaced$str(), (Object)arg0);
    }

    protected String propertyCouldNotBeReplaced$str() {
        return propertyCouldNotBeReplaced;
    }

    public final void ignoringException(String arg0, String arg1, Throwable arg2) {
        this.log.logf(FQCN, Logger.Level.WARN, arg2, this.ignoringException$str(), (Object)arg0, (Object)arg1);
    }

    protected String ignoringException$str() {
        return ignoringException;
    }

    public final void unableToSetValue(Exception arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)arg0, this.unableToSetValue$str(), new Object[0]);
    }

    protected String unableToSetValue$str() {
        return unableToSetValue;
    }

    public final CacheConfigurationException sslInitializationException(Throwable arg0) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.sslInitializationException$str(), new Object[0]), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sslInitializationException$str() {
        return sslInitializationException;
    }

    public final void unableToLoadClass(String arg0, String arg1, Throwable arg2) {
        this.log.logf(FQCN, Logger.Level.ERROR, arg2, this.unableToLoadClass$str(), (Object)arg0, (Object)arg1);
    }

    protected String unableToLoadClass$str() {
        return unableToLoadClass;
    }

    public final void unableToConvertStringPropertyToInt(String arg0, int arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToConvertStringPropertyToInt$str(), (Object)arg0, (Object)arg1);
    }

    protected String unableToConvertStringPropertyToInt$str() {
        return unableToConvertStringPropertyToInt;
    }

    public final void unableToConvertStringPropertyToLong(String arg0, long arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToConvertStringPropertyToLong$str(), (Object)arg0, (Object)arg1);
    }

    protected String unableToConvertStringPropertyToLong$str() {
        return unableToConvertStringPropertyToLong;
    }

    public final void unableToConvertStringPropertyToBoolean(String arg0, boolean arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToConvertStringPropertyToBoolean$str(), (Object)arg0, (Object)arg1);
    }

    protected String unableToConvertStringPropertyToBoolean$str() {
        return unableToConvertStringPropertyToBoolean;
    }

    public final IllegalArgumentException unableToUnwrap(Object arg0, Class arg1) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.unableToUnwrap$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToUnwrap$str() {
        return unableToUnwrap;
    }

    public final CacheConfigurationException illegalValueThreadPoolParameter(String arg0, String arg1) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.illegalValueThreadPoolParameter$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalValueThreadPoolParameter$str() {
        return illegalValueThreadPoolParameter;
    }

    public final IllegalArgumentException unableToUnwrapAny(String arg0, Class arg1) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.unableToUnwrapAny$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToUnwrapAny$str() {
        return unableToUnwrapAny;
    }

    public final IllegalStateException unprotectedAttributeSet(String arg0) {
        IllegalStateException result = new IllegalStateException(String.format(this.unprotectedAttributeSet$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unprotectedAttributeSet$str() {
        return unprotectedAttributeSet;
    }

    public final IllegalStateException protectedAttributeSet(String arg0) {
        IllegalStateException result = new IllegalStateException(String.format(this.protectedAttributeSet$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String protectedAttributeSet$str() {
        return protectedAttributeSet;
    }

    public final IllegalArgumentException attributeSetDuplicateAttribute(String arg0, String arg1) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.attributeSetDuplicateAttribute$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributeSetDuplicateAttribute$str() {
        return attributeSetDuplicateAttribute;
    }

    public final IllegalArgumentException noSuchAttribute(String arg0, String arg1) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.noSuchAttribute$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuchAttribute$str() {
        return noSuchAttribute;
    }

    public final IllegalArgumentException noAttributeCopierForType(Class arg0) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.noAttributeCopierForType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noAttributeCopierForType$str() {
        return noAttributeCopierForType;
    }

    public final UnsupportedOperationException cannotResizeUnboundedContainer() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.cannotResizeUnboundedContainer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotResizeUnboundedContainer$str() {
        return cannotResizeUnboundedContainer;
    }

    public final IOException cannotFindResource(String arg0) {
        IOException result = new IOException(String.format(this.cannotFindResource$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindResource$str() {
        return cannotFindResource;
    }

    public final CacheConfigurationException multipleConfigurationValidationErrors() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.multipleConfigurationValidationErrors$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleConfigurationValidationErrors$str() {
        return multipleConfigurationValidationErrors;
    }

    public final UnsupportedOperationException unableToLoadFileUsingScheme(String arg0) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.unableToLoadFileUsingScheme$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadFileUsingScheme$str() {
        return unableToLoadFileUsingScheme;
    }

    public final SecurityException noSuchAliasInKeyStore(String arg0, String arg1) {
        SecurityException result = new SecurityException(String.format(this.noSuchAliasInKeyStore$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuchAliasInKeyStore$str() {
        return noSuchAliasInKeyStore;
    }

    public final void errorRollingBack(Throwable arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, arg0, this.errorRollingBack$str(), new Object[0]);
    }

    protected String errorRollingBack$str() {
        return errorRollingBack;
    }

    public final void errorEnlistingResource(Throwable arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, arg0, this.errorEnlistingResource$str(), new Object[0]);
    }

    protected String errorEnlistingResource$str() {
        return errorEnlistingResource;
    }

    public final void beforeCompletionFailed(String arg0, Throwable arg1) {
        this.log.logf(FQCN, Logger.Level.ERROR, arg1, this.beforeCompletionFailed$str(), (Object)arg0);
    }

    protected String beforeCompletionFailed$str() {
        return beforeCompletionFailed;
    }

    public final void unexpectedErrorFromResourceManager(Throwable arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, arg0, this.unexpectedErrorFromResourceManager$str(), new Object[0]);
    }

    protected String unexpectedErrorFromResourceManager$str() {
        return unexpectedErrorFromResourceManager;
    }

    public final void afterCompletionFailed(String arg0, Throwable arg1) {
        this.log.logf(FQCN, Logger.Level.ERROR, arg1, this.afterCompletionFailed$str(), (Object)arg0);
    }

    protected String afterCompletionFailed$str() {
        return afterCompletionFailed;
    }

    public final void errorCommittingTx(Throwable arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, arg0, this.errorCommittingTx$str(), new Object[0]);
    }

    protected String errorCommittingTx$str() {
        return errorCommittingTx;
    }

    public final void xaResourceEndFailed(String arg0, Throwable arg1) {
        this.log.logf(FQCN, Logger.Level.ERROR, arg1, this.xaResourceEndFailed$str(), (Object)arg0);
    }

    protected String xaResourceEndFailed$str() {
        return xaResourceEndFailed;
    }

    public final EncodingException missingMediaType() {
        EncodingException result = new EncodingException(String.format(this.missingMediaType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingMediaType$str() {
        return missingMediaType;
    }

    public final EncodingException invalidMediaTypeSubtype() {
        EncodingException result = new EncodingException(String.format(this.invalidMediaTypeSubtype$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMediaTypeSubtype$str() {
        return invalidMediaTypeSubtype;
    }

    public final EncodingException invalidMediaTypeParam(String arg0) {
        EncodingException result = new EncodingException(String.format(this.invalidMediaTypeParam$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMediaTypeParam$str() {
        return invalidMediaTypeParam;
    }

    public final EncodingException unquotedMediaTypeParam() {
        EncodingException result = new EncodingException(String.format(this.unquotedMediaTypeParam$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unquotedMediaTypeParam$str() {
        return unquotedMediaTypeParam;
    }

    public final EncodingException invalidCharMediaType(char arg0, String arg1) {
        EncodingException result = new EncodingException(String.format(this.invalidCharMediaType$str(), Character.valueOf(arg0), arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCharMediaType$str() {
        return invalidCharMediaType;
    }

    public final EncodingException unsupportedContent(Object arg0) {
        EncodingException result = new EncodingException(String.format(this.unsupportedContent$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedContent$str() {
        return unsupportedContent;
    }

    public final CounterOutOfBoundsException counterOurOfBounds(String arg0) {
        CounterOutOfBoundsException result = new CounterOutOfBoundsException(String.format(this.counterOurOfBounds$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String counterOurOfBounds$str() {
        return counterOurOfBounds;
    }

    public final CounterException invalidCounterType(String arg0, String arg1) {
        CounterException result = new CounterException(String.format(this.invalidCounterType$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCounterType$str() {
        return invalidCounterType;
    }

    public final CounterException undefinedCounter(String arg0) {
        CounterException result = new CounterException(String.format(this.undefinedCounter$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String undefinedCounter$str() {
        return undefinedCounter;
    }

    public final CounterException invalidCounterTypeEncoded() {
        CounterException result = new CounterException(String.format(this.invalidCounterTypeEncoded$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCounterTypeEncoded$str() {
        return invalidCounterTypeEncoded;
    }
}

