/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.StrongCounterConfiguration;
import org.infinispan.counter.configuration.WeakCounterConfiguration;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.listener.CounterManagerNotificationManager;
import org.infinispan.util.concurrent.CompletableFutures;

public class CacheHolder {
    private final AdvancedCache<String, CounterConfiguration> configurationCache;
    private final AdvancedCache<? extends CounterKey, CounterValue> counterCache;
    private final List<AbstractCounterConfiguration> defaultCounters;

    public CacheHolder(AdvancedCache<String, CounterConfiguration> configurationCache, AdvancedCache<? extends CounterKey, CounterValue> counterCache, List<AbstractCounterConfiguration> defaultCounters) {
        this.configurationCache = configurationCache;
        this.counterCache = counterCache;
        this.defaultCounters = defaultCounters;
    }

    Collection<String> getCounterNames() {
        HashSet countersName = new HashSet(this.configurationCache.keySet());
        this.defaultCounters.stream().map(AbstractCounterConfiguration::name).forEach(countersName::add);
        return Collections.unmodifiableCollection(countersName);
    }

    void registerNotificationManager(CounterManagerNotificationManager notificationManager) {
        notificationManager.listenOn((Cache<? extends CounterKey, CounterValue>)this.counterCache);
    }

    CompletableFuture<Boolean> addConfigurationAsync(String name, CounterConfiguration configuration) {
        return ((CompletableFuture)this.checkAndStoreConfiguredCounterConfigurationAsync(name).thenCompose(fileConfig -> {
            if (fileConfig != null) {
                return CompletableFuture.completedFuture(fileConfig);
            }
            return this.configCacheWithFlags(configuration).putIfAbsentAsync((Object)name, (Object)configuration);
        })).thenApply(Objects::isNull);
    }

    <K extends CounterKey> AdvancedCache<K, CounterValue> getCounterCache(CounterConfiguration configuration) {
        return configuration.storage() == Storage.VOLATILE ? this.counterCache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE}) : this.counterCache;
    }

    CompletableFuture<CounterConfiguration> getConfigurationAsync(String counterName) {
        return this.configurationCache.getAsync((Object)counterName).thenCompose(existingConfiguration -> {
            if (existingConfiguration == null) {
                return this.checkAndStoreConfiguredCounterConfigurationAsync(counterName);
            }
            return CompletableFuture.completedFuture(existingConfiguration);
        });
    }

    private Cache<String, CounterConfiguration> configCacheWithFlags(CounterConfiguration config) {
        return config.storage() == Storage.VOLATILE ? this.configurationCache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD}) : this.configurationCache;
    }

    private CompletableFuture<CounterConfiguration> checkAndStoreConfiguredCounterConfigurationAsync(String name) {
        for (AbstractCounterConfiguration config : this.defaultCounters) {
            if (!config.name().equals(name)) continue;
            CounterConfiguration counterConfiguration = CacheHolder.createConfigurationEntry(config);
            return this.configurationCache.putIfAbsentAsync((Object)name, (Object)counterConfiguration).thenApply(configuration -> configuration == null ? counterConfiguration : configuration);
        }
        return CompletableFutures.completedNull();
    }

    private static CounterConfiguration createConfigurationEntry(AbstractCounterConfiguration configuration) {
        if (configuration instanceof StrongCounterConfiguration) {
            if (((StrongCounterConfiguration)configuration).isBound()) {
                return CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(configuration.initialValue()).lowerBound(((StrongCounterConfiguration)configuration).lowerBound()).upperBound(((StrongCounterConfiguration)configuration).upperBound()).storage(configuration.storage()).build();
            }
            return CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue(configuration.initialValue()).storage(configuration.storage()).build();
        }
        if (configuration instanceof WeakCounterConfiguration) {
            return CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(configuration.initialValue()).storage(configuration.storage()).concurrencyLevel(((WeakCounterConfiguration)configuration).concurrencyLevel()).build();
        }
        throw new IllegalStateException("[should never happen] unknown CounterConfiguration class: " + configuration.getClass());
    }
}

