/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.logging;

import java.io.Serializable;
import java.util.Arrays;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.counter.exception.CounterConfigurationException;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.counter.logging.Log;
import org.infinispan.util.ByteString;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Serializable,
Log,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final String missingCounterName = "ISPN028003: The counter name is missing.";
    private static final String invalidStorageMode = "ISPN028004: Invalid storage mode. It must be non-null";
    private static final String invalidPersistentStorageMode = "ISPN028005: Invalid storage mode. PERSISTENT is not allowed without global state enabled in cache container.";
    private static final String invalidNumOwners = "ISPN028006: Invalid number of owner. It must be higher than zero but it was %s";
    private static final String invalidReliabilityMode = "ISPN028007: Invalid reliability mode. It must be non-null";
    private static final String invalidInitialValueForBoundedCounter = "ISPN028008: Invalid initial value for counter. It must be between %s and %s (inclusive) but was %s";
    private static final String invalidConcurrencyLevel = "ISPN028009: Invalid concurrency-level. It must be higher than zero but it was %s";
    private static final String interruptedWhileWaitingForCaches = "ISPN028012: Interrupted while waiting for the counter manager caches.";
    private static final String exceptionWhileWaitingForCached = "ISPN028013: Exception while waiting for counter manager caches.";
    private static final String invalidCounterType = "ISPN028014: Invalid counter type. Expected=%s but got %s";
    private static final String unableToFetchCaches = "ISPN028015: Unable to fetch counter manager caches.";
    private static final String undefinedCounter = "ISPN028016: Counter '%s' is not defined.";
    private static final String duplicatedCounterName = "ISPN028017: Duplicated counter name found. Counter '%s' already exists.";
    private static final String metadataIsMissing = "ISPN028018: Metadata not found but counter exists. Counter=%s";
    private static final String invalidScope = "ISPN028020: Invalid scope for tag <counter>. Expected CACHE_CONTAINER but was %s";
    private static final String invalidSameLowerAndUpperBound = "ISPN028024: Lower bound (%s) and upper bound (%s) can't be the same.";

    public Log_$logger(Logger log) {
        super(log);
    }

    @Override
    public final CounterConfigurationException missingCounterName() {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.missingCounterName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingCounterName$str() {
        return missingCounterName;
    }

    @Override
    public final CounterConfigurationException invalidStorageMode() {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidStorageMode$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidStorageMode$str() {
        return invalidStorageMode;
    }

    @Override
    public final CounterConfigurationException invalidPersistentStorageMode() {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidPersistentStorageMode$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPersistentStorageMode$str() {
        return invalidPersistentStorageMode;
    }

    @Override
    public final CounterConfigurationException invalidNumOwners(int value) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidNumOwners$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNumOwners$str() {
        return invalidNumOwners;
    }

    @Override
    public final CounterConfigurationException invalidReliabilityMode() {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidReliabilityMode$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidReliabilityMode$str() {
        return invalidReliabilityMode;
    }

    @Override
    public final CounterConfigurationException invalidInitialValueForBoundedCounter(long lower, long upper, long value) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidInitialValueForBoundedCounter$str(), lower, upper, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidInitialValueForBoundedCounter$str() {
        return invalidInitialValueForBoundedCounter;
    }

    @Override
    public final CounterConfigurationException invalidConcurrencyLevel(int value) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidConcurrencyLevel$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConcurrencyLevel$str() {
        return invalidConcurrencyLevel;
    }

    @Override
    public final void interruptedWhileWaitingForCaches() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.interruptedWhileWaitingForCaches$str(), new Object[0]);
    }

    protected String interruptedWhileWaitingForCaches$str() {
        return interruptedWhileWaitingForCaches;
    }

    @Override
    public final void exceptionWhileWaitingForCached(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.exceptionWhileWaitingForCached$str(), new Object[0]);
    }

    protected String exceptionWhileWaitingForCached$str() {
        return exceptionWhileWaitingForCached;
    }

    @Override
    public final CounterException invalidCounterType(String expected, String actual) {
        CounterException result = new CounterException(String.format(this.invalidCounterType$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCounterType$str() {
        return invalidCounterType;
    }

    @Override
    public final CounterException unableToFetchCaches() {
        CounterException result = new CounterException(String.format(this.unableToFetchCaches$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToFetchCaches$str() {
        return unableToFetchCaches;
    }

    @Override
    public final CounterException undefinedCounter(String name) {
        CounterException result = new CounterException(String.format(this.undefinedCounter$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String undefinedCounter$str() {
        return undefinedCounter;
    }

    @Override
    public final CounterConfigurationException duplicatedCounterName(String counter) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.duplicatedCounterName$str(), counter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicatedCounterName$str() {
        return duplicatedCounterName;
    }

    @Override
    public final IllegalStateException metadataIsMissing(ByteString counterName) {
        IllegalStateException result = new IllegalStateException(String.format(this.metadataIsMissing$str(), counterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String metadataIsMissing$str() {
        return metadataIsMissing;
    }

    @Override
    public final CounterConfigurationException invalidScope(ParserScope scope) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidScope$str(), scope));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidScope$str() {
        return invalidScope;
    }

    @Override
    public final CounterConfigurationException invalidSameLowerAndUpperBound(long lower, long upper) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.invalidSameLowerAndUpperBound$str(), lower, upper));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSameLowerAndUpperBound$str() {
        return invalidSameLowerAndUpperBound;
    }
}

