/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.logging.Log;

public abstract class AbstractCounterConfiguration {
    static final AttributeDefinition<Long> INITIAL_VALUE = AttributeDefinition.builder((String)"initialValue", (Object)0L).xmlName("initial-value").immutable().build();
    private static final Log log = (Log)LogFactory.getLog(AbstractCounterConfiguration.class, Log.class);
    static final AttributeDefinition<Storage> STORAGE = AttributeDefinition.builder((String)"storage", (Object)Storage.VOLATILE).xmlName("storage").validator(value -> {
        if (value == null) {
            throw log.invalidStorageMode();
        }
    }).immutable().build();
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", null, String.class).xmlName("name").validator(value -> {
        if (value == null) {
            throw log.missingCounterName();
        }
    }).immutable().build();
    final AttributeSet attributes;

    AbstractCounterConfiguration(AttributeSet attributes) {
        this.attributes = attributes;
    }

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AbstractCounterConfiguration.class, new AttributeDefinition[]{NAME, INITIAL_VALUE, STORAGE});
    }

    final AttributeSet attributes() {
        return this.attributes;
    }

    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public long initialValue() {
        return (Long)this.attributes.attribute(INITIAL_VALUE).get();
    }

    public Storage storage() {
        return (Storage)this.attributes.attribute(STORAGE).get();
    }
}

