/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.counter.configuration.AbstractCounterConfigurationBuilder;
import org.infinispan.counter.configuration.CounterManagerConfiguration;
import org.infinispan.counter.configuration.Reliability;
import org.infinispan.counter.configuration.StrongCounterConfigurationBuilder;
import org.infinispan.counter.configuration.WeakCounterConfigurationBuilder;
import org.infinispan.counter.logging.Log;

public class CounterManagerConfigurationBuilder
implements Builder<CounterManagerConfiguration> {
    private static final CounterManagerConfiguration DEFAULT = new CounterManagerConfigurationBuilder(null).create();
    private static final Log log = (Log)LogFactory.getLog(CounterManagerConfigurationBuilder.class, Log.class);
    private final AttributeSet attributes = CounterManagerConfiguration.attributeDefinitionSet();
    private final List<AbstractCounterConfigurationBuilder> defaultCounters = new ArrayList<AbstractCounterConfigurationBuilder>(2);
    private final GlobalConfigurationBuilder builder;

    public CounterManagerConfigurationBuilder(GlobalConfigurationBuilder builder) {
        this.builder = builder;
    }

    public static CounterManagerConfiguration defaultConfiguration() {
        return DEFAULT;
    }

    public CounterManagerConfigurationBuilder numOwner(int numOwners) {
        this.attributes.attribute(CounterManagerConfiguration.NUM_OWNERS).set((Object)numOwners);
        return this;
    }

    public CounterManagerConfigurationBuilder reliability(Reliability reliability) {
        this.attributes.attribute(CounterManagerConfiguration.RELIABILITY).set((Object)reliability);
        return this;
    }

    public StrongCounterConfigurationBuilder addStrongCounter() {
        StrongCounterConfigurationBuilder builder = new StrongCounterConfigurationBuilder(this);
        this.defaultCounters.add(builder);
        return builder;
    }

    public WeakCounterConfigurationBuilder addWeakCounter() {
        WeakCounterConfigurationBuilder builder = new WeakCounterConfigurationBuilder(this);
        this.defaultCounters.add(builder);
        return builder;
    }

    public void validate() {
        this.attributes.attributes().forEach(Attribute::validate);
        this.defaultCounters.forEach(AbstractCounterConfigurationBuilder::validate);
        HashSet<String> counterNames = new HashSet<String>();
        for (AbstractCounterConfigurationBuilder builder : this.defaultCounters) {
            if (counterNames.add(builder.name())) continue;
            throw log.duplicatedCounterName(builder.name());
        }
    }

    public CounterManagerConfiguration create() {
        ArrayList<Object> counters = new ArrayList<Object>(this.defaultCounters.size());
        for (AbstractCounterConfigurationBuilder builder : this.defaultCounters) {
            counters.add(builder.create());
        }
        return new CounterManagerConfiguration(this.attributes.protect(), counters);
    }

    public Builder<?> read(CounterManagerConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public void clearCounters() {
        this.defaultCounters.clear();
    }

    boolean isGlobalStateEnabled() {
        return this.builder.globalState().enabled();
    }
}

