
package org.infinispan.counter.logging;

import java.io.File;
import java.io.Serializable;
import javax.annotation.Generated;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.util.ByteString;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;


/**
 * Warning this class consists of generated code.
 * 
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-11-01T12:32:19+0000")
public class Log_$logger
    extends DelegatingBasicLogger
    implements Serializable, Log, BasicLogger
{

    private final static long serialVersionUID = 1L;
    private final static java.lang.String FQCN = Log_$logger.class.getName();
    private final static java.lang.String missingCounterName = "ISPN028003: The counter name is missing.";
    private final static java.lang.String invalidStorageMode = "ISPN028004: Invalid storage mode. It must be non-null";
    private final static java.lang.String invalidPersistentStorageMode = "ISPN028005: Invalid storage mode. PERSISTENT is not allowed without global state enabled in cache container.";
    private final static java.lang.String invalidNumOwners = "ISPN028006: Invalid number of owner. It must be higher than zero but it was %s";
    private final static java.lang.String invalidReliabilityMode = "ISPN028007: Invalid reliability mode. It must be non-null";
    private final static java.lang.String invalidInitialValueForBoundedCounter = "ISPN028008: Invalid initial value for counter. It must be between %s and %s (inclusive) but was %s";
    private final static java.lang.String invalidConcurrencyLevel = "ISPN028009: Invalid concurrency-level. It must be higher than zero but it was %s";
    private final static java.lang.String invalidCounterType = "ISPN028014: Invalid counter type. Expected=%s but got %s";
    private final static java.lang.String unableToFetchCaches = "ISPN028015: Unable to fetch counter manager caches.";
    private final static java.lang.String undefinedCounter = "ISPN028016: Counter '%s' is not defined.";
    private final static java.lang.String duplicatedCounterName = "ISPN028017: Duplicated counter name found. Counter '%s' already exists.";
    private final static java.lang.String metadataIsMissing = "ISPN028018: Metadata not found but counter exists. Counter=%s";
    private final static java.lang.String invalidScope = "ISPN028020: Invalid scope for tag <counter>. Expected CACHE_CONTAINER but was %s";
    private final static java.lang.String invalidSameLowerAndUpperBound = "ISPN028024: Lower bound (%s) and upper bound (%s) can't be the same.";
    private final static java.lang.String cannotRenamePersistentFile = "ISPN028025: Cannot rename file %s to %s";
    private final static java.lang.String errorPersistingCountersConfiguration = "ISPN028026: Error while persisting counter's configurations";
    private final static java.lang.String errorReadingCountersConfiguration = "ISPN028027: Error while reading counter's configurations";
    private final static java.lang.String managerNotStarted = "ISPN028028: CounterManager hasn't started yet or has been stopped.";

    public Log_$logger(final Logger log) {
        super(log);
    }

    public final org.infinispan.counter.exception.CounterConfigurationException missingCounterName() {
        org.infinispan.counter.exception.CounterConfigurationException result = new org.infinispan.counter.exception.CounterConfigurationException(java.lang.String.format(missingCounterName$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String missingCounterName$str() {
        return missingCounterName;
    }

    public final org.infinispan.counter.exception.CounterConfigurationException invalidStorageMode() {
        org.infinispan.counter.exception.CounterConfigurationException result = new org.infinispan.counter.exception.CounterConfigurationException(java.lang.String.format(invalidStorageMode$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidStorageMode$str() {
        return invalidStorageMode;
    }

    public final org.infinispan.counter.exception.CounterConfigurationException invalidPersistentStorageMode() {
        org.infinispan.counter.exception.CounterConfigurationException result = new org.infinispan.counter.exception.CounterConfigurationException(java.lang.String.format(invalidPersistentStorageMode$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidPersistentStorageMode$str() {
        return invalidPersistentStorageMode;
    }

    public final org.infinispan.counter.exception.CounterConfigurationException invalidNumOwners(final int value) {
        org.infinispan.counter.exception.CounterConfigurationException result = new org.infinispan.counter.exception.CounterConfigurationException(java.lang.String.format(invalidNumOwners$str(), value));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidNumOwners$str() {
        return invalidNumOwners;
    }

    public final org.infinispan.counter.exception.CounterConfigurationException invalidReliabilityMode() {
        org.infinispan.counter.exception.CounterConfigurationException result = new org.infinispan.counter.exception.CounterConfigurationException(java.lang.String.format(invalidReliabilityMode$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidReliabilityMode$str() {
        return invalidReliabilityMode;
    }

    public final org.infinispan.counter.exception.CounterConfigurationException invalidInitialValueForBoundedCounter(final long lower, final long upper, final long value) {
        org.infinispan.counter.exception.CounterConfigurationException result = new org.infinispan.counter.exception.CounterConfigurationException(java.lang.String.format(invalidInitialValueForBoundedCounter$str(), lower, upper, value));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidInitialValueForBoundedCounter$str() {
        return invalidInitialValueForBoundedCounter;
    }

    public final org.infinispan.counter.exception.CounterConfigurationException invalidConcurrencyLevel(final int value) {
        org.infinispan.counter.exception.CounterConfigurationException result = new org.infinispan.counter.exception.CounterConfigurationException(java.lang.String.format(invalidConcurrencyLevel$str(), value));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidConcurrencyLevel$str() {
        return invalidConcurrencyLevel;
    }

    public final org.infinispan.counter.exception.CounterException invalidCounterType(final java.lang.String expected, final java.lang.String actual) {
        org.infinispan.counter.exception.CounterException result = new org.infinispan.counter.exception.CounterException(java.lang.String.format(invalidCounterType$str(), expected, actual));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidCounterType$str() {
        return invalidCounterType;
    }

    public final org.infinispan.counter.exception.CounterException unableToFetchCaches() {
        org.infinispan.counter.exception.CounterException result = new org.infinispan.counter.exception.CounterException(java.lang.String.format(unableToFetchCaches$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String unableToFetchCaches$str() {
        return unableToFetchCaches;
    }

    public final org.infinispan.counter.exception.CounterException undefinedCounter(final java.lang.String name) {
        org.infinispan.counter.exception.CounterException result = new org.infinispan.counter.exception.CounterException(java.lang.String.format(undefinedCounter$str(), name));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String undefinedCounter$str() {
        return undefinedCounter;
    }

    public final org.infinispan.counter.exception.CounterConfigurationException duplicatedCounterName(final java.lang.String counter) {
        org.infinispan.counter.exception.CounterConfigurationException result = new org.infinispan.counter.exception.CounterConfigurationException(java.lang.String.format(duplicatedCounterName$str(), counter));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String duplicatedCounterName$str() {
        return duplicatedCounterName;
    }

    public final java.lang.IllegalStateException metadataIsMissing(final ByteString counterName) {
        java.lang.IllegalStateException result = new java.lang.IllegalStateException(java.lang.String.format(metadataIsMissing$str(), counterName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String metadataIsMissing$str() {
        return metadataIsMissing;
    }

    public final org.infinispan.counter.exception.CounterConfigurationException invalidScope(final ParserScope scope) {
        org.infinispan.counter.exception.CounterConfigurationException result = new org.infinispan.counter.exception.CounterConfigurationException(java.lang.String.format(invalidScope$str(), scope));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidScope$str() {
        return invalidScope;
    }

    public final org.infinispan.counter.exception.CounterConfigurationException invalidSameLowerAndUpperBound(final long lower, final long upper) {
        org.infinispan.counter.exception.CounterConfigurationException result = new org.infinispan.counter.exception.CounterConfigurationException(java.lang.String.format(invalidSameLowerAndUpperBound$str(), lower, upper));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidSameLowerAndUpperBound$str() {
        return invalidSameLowerAndUpperBound;
    }

    public final org.infinispan.counter.exception.CounterConfigurationException cannotRenamePersistentFile(final java.lang.String absolutePath, final File persistentFile) {
        org.infinispan.counter.exception.CounterConfigurationException result = new org.infinispan.counter.exception.CounterConfigurationException(java.lang.String.format(cannotRenamePersistentFile$str(), absolutePath, persistentFile));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String cannotRenamePersistentFile$str() {
        return cannotRenamePersistentFile;
    }

    public final org.infinispan.counter.exception.CounterConfigurationException errorPersistingCountersConfiguration(final java.lang.Throwable cause) {
        org.infinispan.counter.exception.CounterConfigurationException result = new org.infinispan.counter.exception.CounterConfigurationException(java.lang.String.format(errorPersistingCountersConfiguration$str()), cause);
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String errorPersistingCountersConfiguration$str() {
        return errorPersistingCountersConfiguration;
    }

    public final org.infinispan.counter.exception.CounterConfigurationException errorReadingCountersConfiguration(final java.lang.Throwable cause) {
        org.infinispan.counter.exception.CounterConfigurationException result = new org.infinispan.counter.exception.CounterConfigurationException(java.lang.String.format(errorReadingCountersConfiguration$str()), cause);
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String errorReadingCountersConfiguration$str() {
        return errorReadingCountersConfiguration;
    }

    public final org.infinispan.counter.exception.CounterException managerNotStarted() {
        org.infinispan.counter.exception.CounterException result = new org.infinispan.counter.exception.CounterException(java.lang.String.format(managerNotStarted$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String managerNotStarted$str() {
        return managerNotStarted;
    }

}
