/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.impl.externalizers.ExternalizerIds;
import org.infinispan.counter.util.Utils;

@Immutable
public class CounterValue {
    public static final AdvancedExternalizer<CounterValue> EXTERNALIZER = new Externalizer();
    private static final CounterValue ZERO = new CounterValue(0L, CounterState.VALID);
    private final long value;
    private final CounterState state;

    private CounterValue(long value, CounterState state) {
        this.value = value;
        this.state = state;
    }

    public static CounterValue newCounterValue(long value) {
        return value == 0L ? ZERO : new CounterValue(value, CounterState.VALID);
    }

    public static CounterValue newCounterValue(long value, long lowerBound, long upperBound) {
        return new CounterValue(value, Utils.calculateState(value, lowerBound, upperBound));
    }

    public static CounterValue newCounterValue(long value, CounterState state) {
        return new CounterValue(value, state);
    }

    public static CounterValue newCounterValue(CounterConfiguration configuration) {
        return configuration.type() == CounterType.BOUNDED_STRONG ? CounterValue.newCounterValue(configuration.initialValue(), configuration.lowerBound(), configuration.upperBound()) : CounterValue.newCounterValue(configuration.initialValue());
    }

    public static CounterValue newCounterValue(long currentValue, CounterConfiguration configuration) {
        return configuration.type() == CounterType.BOUNDED_STRONG ? CounterValue.newCounterValue(currentValue, configuration.lowerBound(), configuration.upperBound()) : CounterValue.newCounterValue(currentValue);
    }

    public long getValue() {
        return this.value;
    }

    public CounterState getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterValue that = (CounterValue)o;
        return this.value == that.value && this.state == that.state;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + this.state.hashCode();
        return result;
    }

    public String toString() {
        return "CounterValue{value=" + this.value + ", state=" + this.state + '}';
    }

    private static class Externalizer
    implements AdvancedExternalizer<CounterValue> {
        private Externalizer() {
        }

        public Set<Class<? extends CounterValue>> getTypeClasses() {
            return Collections.singleton(CounterValue.class);
        }

        public Integer getId() {
            return ExternalizerIds.COUNTER_VALUE;
        }

        public void writeObject(ObjectOutput output, CounterValue object) throws IOException {
            output.writeLong(object.value);
            MarshallUtil.marshallEnum((Enum)object.state, (ObjectOutput)output);
        }

        public CounterValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            long value = input.readLong();
            CounterState state = (CounterState)MarshallUtil.unmarshallEnum((ObjectInput)input, CounterState::valueOf);
            if (value == 0L && state == CounterState.VALID) {
                return ZERO;
            }
            return new CounterValue(value, state);
        }
    }
}

