/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.lock;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.lock.logging.Log;

public class RequestExpirationScheduler {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ScheduledExecutorService scheduledExecutorService;
    private final ConcurrentMap<String, ScheduledRequest> scheduledRequests = new ConcurrentHashMap<String, ScheduledRequest>();

    public RequestExpirationScheduler(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void scheduleForCompletion(String requestId, CompletableFuture<Boolean> request, long time, TimeUnit unit) {
        if (request.isDone()) {
            if (trace) {
                log.tracef("Request[%s] is not scheduled because is already done", requestId);
            }
            return;
        }
        if (this.scheduledRequests.containsKey(requestId)) {
            String message = String.format("Request[%s] is not scheduled because it is already scheduled", requestId);
            log.error(message);
            throw new IllegalStateException(message);
        }
        if (trace) {
            log.tracef("Request[%s] being scheduled to be completed in [%d, %s]", requestId, time, (Object)unit);
        }
        ScheduledFuture<?> scheduledFuture = this.scheduledExecutorService.schedule(() -> {
            request.complete(false);
            this.scheduledRequests.remove(requestId);
        }, time, unit);
        this.scheduledRequests.putIfAbsent(requestId, new ScheduledRequest(request, scheduledFuture));
    }

    public void abortScheduling(String requestId) {
        this.abortScheduling(requestId, false);
    }

    public void abortScheduling(String requestId, boolean force) {
        ScheduledRequest scheduledRequest;
        if (trace) {
            log.tracef("Request[%s] abort scheduling", requestId);
        }
        if ((scheduledRequest = (ScheduledRequest)this.scheduledRequests.get(requestId)) != null && (scheduledRequest.request.isDone() || force)) {
            scheduledRequest.scheduledFuture.cancel(false);
            this.scheduledRequests.remove(requestId);
        }
    }

    public int countScheduledRequests() {
        return this.scheduledRequests.size();
    }

    public ScheduledRequest get(String requestId) {
        return (ScheduledRequest)this.scheduledRequests.get(requestId);
    }

    public void clear() {
        this.scheduledRequests.clear();
    }

    class ScheduledRequest {
        private CompletableFuture<Boolean> request;
        private ScheduledFuture<?> scheduledFuture;

        public ScheduledRequest(CompletableFuture<Boolean> request, ScheduledFuture<?> scheduledFuture) {
            this.request = request;
            this.scheduledFuture = scheduledFuture;
        }

        public CompletableFuture<Boolean> getRequest() {
            return this.request;
        }

        public ScheduledFuture<?> getScheduledFuture() {
            return this.scheduledFuture;
        }
    }
}

