/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.functions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.lock.impl.entries.ClusteredLockKey;
import org.infinispan.lock.impl.entries.ClusteredLockState;
import org.infinispan.lock.impl.entries.ClusteredLockValue;
import org.infinispan.lock.impl.externalizers.ExternalizerIds;
import org.infinispan.lock.logging.Log;

public class UnlockFunction
implements Function<EntryView.ReadWriteEntryView<ClusteredLockKey, ClusteredLockValue>, Boolean> {
    private static final Log log = (Log)LogFactory.getLog(UnlockFunction.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    public static final AdvancedExternalizer<UnlockFunction> EXTERNALIZER = new Externalizer();
    private final String requestId;
    private final Set<Object> requestors;

    public UnlockFunction(Object requestor) {
        this.requestId = null;
        this.requestors = Collections.singleton(requestor);
    }

    public UnlockFunction(String requestId, Set<Object> requestors) {
        this.requestId = requestId;
        this.requestors = requestors;
    }

    @Override
    public Boolean apply(EntryView.ReadWriteEntryView<ClusteredLockKey, ClusteredLockValue> entryView) {
        boolean ownerMatches;
        ClusteredLockValue lockValue;
        if (trace) {
            log.tracef("Lock[%s] unlock request by reqId [%s] requestors %s", ((ClusteredLockKey)entryView.key()).getName(), this.requestId, this.requestors);
        }
        if ((lockValue = (ClusteredLockValue)entryView.find().orElseThrow(() -> log.lockDeleted())).getState() == ClusteredLockState.RELEASED) {
            if (trace) {
                log.tracef("Lock[%s] Already free. State[RELEASED], reqId [%s], owner [%s]", ((ClusteredLockKey)entryView.key()).getName(), lockValue.getRequestId(), lockValue.getOwner());
            }
            return Boolean.TRUE;
        }
        boolean requestIdMatches = this.requestId == null || lockValue.getRequestId() != null && lockValue.getRequestId().equals(this.requestId);
        boolean bl = ownerMatches = lockValue.getOwner() != null && this.requestors.contains(lockValue.getOwner());
        if (requestIdMatches && ownerMatches) {
            if (trace) {
                log.tracef("Lock[%s] Unlocked by reqId [%s] requestors %s", ((ClusteredLockKey)entryView.key()).getName(), this.requestId, this.requestors);
            }
            entryView.set((Object)ClusteredLockValue.INITIAL_STATE, new MetaParam.Writable[0]);
            return Boolean.TRUE;
        }
        if (trace) {
            log.tracef("Lock[%s] Unlock not possible by reqId [%s] requestors %s. Current State[ACQUIRED], reqId [%s], owner [%s]", new Object[]{((ClusteredLockKey)entryView.key()).getName(), this.requestId, this.requestors, lockValue.getRequestId(), lockValue.getOwner()});
        }
        return Boolean.FALSE;
    }

    private static class Externalizer
    implements AdvancedExternalizer<UnlockFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends UnlockFunction>> getTypeClasses() {
            return Collections.singleton(UnlockFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.UNLOCK_FUNCTION;
        }

        public void writeObject(ObjectOutput output, UnlockFunction object) throws IOException {
            MarshallUtil.marshallString((String)object.requestId, (ObjectOutput)output);
            output.writeObject(object.requestors);
        }

        public UnlockFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new UnlockFunction(MarshallUtil.unmarshallString((ObjectInput)input), (Set)input.readObject());
        }
    }
}

